/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Blocks;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.BlockModelledMachine;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Items.Tools.ItemDebug;
import Reika.RotaryCraft.Items.Tools.ItemMeter;
import Reika.RotaryCraft.Items.Tools.ItemScrewdriver;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockShaft
extends BlockModelledMachine {
    public BlockShaft(Material mat) {
        super(mat);
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityShaft(meta < 5 ? MaterialRegistry.setType(meta) : MaterialRegistry.STEEL);
    }

    @Override
    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        TileEntityShaft ts = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (ts == null) {
            return 0;
        }
        if (ts.getShaftType().isFlammable()) {
            return 60;
        }
        return 0;
    }

    public float getExplosionResistance(Entity ent, World world, int x, int y, int z, double eX, double eY, double eZ) {
        TileEntityShaft sha = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (sha == null) {
            return 0.0f;
        }
        MaterialRegistry type = sha.getShaftType();
        switch (type) {
            case WOOD: {
                return 3.0f;
            }
            case STONE: {
                return 8.0f;
            }
            case STEEL: 
            case DIAMOND: 
            case BEDROCK: {
                return 15.0f;
            }
        }
        return 0.0f;
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        TileEntityShaft sha = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (sha == null) {
            return 0.01f;
        }
        int mult = 1;
        if (ep.field_71071_by.func_70448_g() != null && ep.field_71071_by.func_70448_g().func_77973_b() == ItemRegistry.BEDPICK.getItemInstance()) {
            mult = 4;
        }
        if (this.canHarvest(world, ep, x, y, z)) {
            return (float)mult * 0.2f / (float)(sha.getShaftType().ordinal() + 1);
        }
        return 0.01f / (float)(sha.getShaftType().ordinal() + 1);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harv) {
        if (this.canHarvest(world, player, x, y, z)) {
            this.func_149636_a(world, player, x, y, z, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int par6, float par7, float par8, float par9) {
        if (RotaryCraft.instance.isLocked()) {
            return false;
        }
        if (ep.func_70093_af()) {
            return true;
        }
        if (ep.func_71045_bC() != null && (ep.func_71045_bC().func_77973_b() instanceof ItemScrewdriver || ep.func_71045_bC().func_77973_b() instanceof ItemMeter || ep.func_71045_bC().func_77973_b() instanceof ItemDebug)) {
            return false;
        }
        TileEntityShaft tile = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (tile != null) {
            ItemStack fix;
            if (tile.getShaftType() == null) {
                return false;
            }
            switch (tile.getShaftType()) {
                case WOOD: {
                    fix = new ItemStack(Items.field_151055_y);
                    break;
                }
                case STONE: {
                    fix = ItemStacks.stonerod;
                    break;
                }
                case STEEL: {
                    fix = ItemStacks.shaftitem;
                    break;
                }
                case DIAMOND: {
                    fix = ItemStacks.diamondshaft;
                    break;
                }
                case BEDROCK: {
                    fix = ItemStacks.bedrockshaft;
                    break;
                }
                default: {
                    fix = new ItemStack(Blocks.field_150348_b);
                }
            }
            if (ep.func_71045_bC() != null && ReikaItemHelper.matchStacks((ItemStack)fix, (ItemStack)ep.func_71045_bC())) {
                tile.repair();
                if (!ep.field_71075_bZ.field_75098_d) {
                    int num = ep.func_71045_bC().field_77994_a;
                    if (num > 1) {
                        ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, ReikaItemHelper.getSizedItemStack((ItemStack)fix, (int)(num - 1)));
                    } else {
                        ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, null);
                    }
                }
                return false;
            }
        }
        return super.func_149727_a(world, x, y, z, ep, par6, par7, par8, par9);
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        TileEntityShaft sha = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (sha != null) {
            if (sha.failed()) {
                ItemStack todrop = null;
                if (this.par5Random.nextInt(8) == 0) {
                    switch (sha.getShaftType()) {
                        case WOOD: {
                            todrop = new ItemStack(Blocks.field_150344_f, 5, 0);
                            break;
                        }
                        case STONE: {
                            todrop = ReikaItemHelper.getSizedItemStack((ItemStack)ReikaItemHelper.cobbleSlab, (int)5);
                            break;
                        }
                        case STEEL: {
                            todrop = ItemStacks.mount.func_77946_l();
                            break;
                        }
                        case DIAMOND: {
                            todrop = ItemStacks.mount.func_77946_l();
                            break;
                        }
                        case BEDROCK: {
                            todrop = ItemStacks.mount.func_77946_l();
                        }
                    }
                    EntityItem item = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), todrop);
                    item.field_145804_b = 10;
                    if (!world.field_72995_K && !ep.field_71075_bZ.field_75098_d) {
                        world.func_72838_d((Entity)item);
                    }
                }
            } else if (sha.func_145832_p() < 6) {
                ItemStack todrop = ItemRegistry.SHAFT.getStackOfMetadata(sha.getShaftType().ordinal());
                if (sha.isUnHarvestable()) {
                    todrop = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)(2 + this.par5Random.nextInt(12)));
                }
                EntityItem item = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), todrop);
                item.field_145804_b = 10;
                if (!world.field_72995_K && !ep.field_71075_bZ.field_75098_d) {
                    world.func_72838_d((Entity)item);
                }
            } else {
                ItemStack todrop = ItemStacks.shaftcross.func_77946_l();
                if (sha.isUnHarvestable()) {
                    todrop = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)(2 + this.par5Random.nextInt(12)));
                }
                EntityItem item = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), todrop);
                item.field_145804_b = 10;
                if (!world.field_72995_K && !ep.field_71075_bZ.field_75098_d) {
                    world.func_72838_d((Entity)item);
                }
            }
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase par5EntityLiving, ItemStack is) {
        int base = 0;
        int heldmeta = par5EntityLiving.func_70694_bm().func_77960_j();
        if (heldmeta == 6) {
            base = 6;
        }
        if (MathHelper.func_76135_e((float)par5EntityLiving.field_70125_A) < 60.0f) {
            int i;
            for (i = MathHelper.func_76128_c((double)((double)(par5EntityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
            }
            while (i < 0) {
                i += 4;
            }
            switch (i) {
                case 0: {
                    world.func_72921_c(x, y, z, base + 0, 3);
                    break;
                }
                case 1: {
                    world.func_72921_c(x, y, z, base + 3, 3);
                    break;
                }
                case 2: {
                    world.func_72921_c(x, y, z, base + 2, 3);
                    break;
                }
                case 3: {
                    world.func_72921_c(x, y, z, base + 1, 3);
                }
            }
        } else {
            if (base == 6) {
                world.func_72921_c(x, y, z, base + 0, 3);
                return;
            }
            if (par5EntityLiving.field_70125_A > 0.0f) {
                world.func_72921_c(x, y, z, 4, 3);
            } else {
                world.func_72921_c(x, y, z, 5, 3);
            }
        }
    }

    public boolean canHarvest(World world, EntityPlayer player, int x, int y, int z) {
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        TileEntityShaft ts = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (ts == null) {
            return false;
        }
        MaterialRegistry type = ts.getShaftType();
        return type != null ? type.isHarvestablePickaxe(player.field_71071_by.func_70448_g()) : false;
    }

    @Override
    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        this.setFullBlockBounds();
        RotaryCraftTileEntity te = (RotaryCraftTileEntity)iba.func_147438_o(x, y, z);
        if (te.func_145832_p() < 6) {
            return;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        float minx = (float)this.field_149759_B;
        float maxx = (float)this.field_149755_E;
        float miny = (float)this.field_149760_C;
        float maxy = (float)this.field_149756_F;
        float minz = (float)this.field_149754_D;
        float maxz = (float)this.field_149757_G;
        this.func_149676_a(minx, miny, minz, maxx, maxy -= 0.1825f, maxz);
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityShaft tile = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (tile == null) {
            return ret;
        }
        ret.add(ItemRegistry.SHAFT.getStackOfMetadata(tile.getShaftType().ordinal()));
        return ret;
    }
}

