/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Blocks;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import Reika.LegacyCraft.LegacyOptions;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.BlockBasic;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public final class BlockCanola
extends BlockBasic
implements IPlantable,
IGrowable,
IWailaDataProvider {
    private final Random rand = new Random();
    private static final HashSet<BlockKey> farmBlocks = new HashSet();
    public static final int GROWN = 9;

    public BlockCanola() {
        super(Material.field_151585_k);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        this.func_149715_a(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149675_a(true);
    }

    @Override
    protected boolean isAvailableInCreativeMode() {
        return false;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return null;
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return ItemStacks.canolaSeeds;
    }

    public boolean isFoliage(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(BlockCanola.getDrops(metadata, fortune, this.rand));
        return ret;
    }

    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if (par2 < 0) {
            par2 = 9;
        }
        if (par2 > 2) {
            par2 += 2;
        }
        if (par2 > 11) {
            par2 = 11;
        }
        return 0;
    }

    public void func_149674_a(World world, int x, int y, int z, Random par5Random) {
        int metadata;
        int l = world.func_72957_l(x, y, z);
        if (!BlockCanola.canSurvive(world, x, y, z)) {
            this.die(world, x, y, z);
        } else if (l >= 9 && (metadata = world.func_72805_g(x, y, z)) < 9 && par5Random.nextInt(3) == 0) {
            world.func_72921_c(x, y, z, ++metadata, 3);
        }
    }

    public void die(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        ReikaItemHelper.dropItem((World)world, (double)x, (double)y, (double)z, (ItemStack)ItemStacks.canolaSeeds);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.testStable(world, x, y, z);
        super.func_149726_b(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block changedid) {
        this.testStable(world, x, y, z);
    }

    public void testStable(World world, int x, int y, int z) {
        if (!BlockCanola.canSurvive(world, x, y, z)) {
            this.die(world, x, y, z);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((float)meta / 9.0f), (double)((double)z + this.field_149757_G));
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, BlockCanola.getPlantHeight(iba.func_72805_g(x, y, z)), 1.0f);
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return 6;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149692_a(int par1) {
        return 0;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @Override
    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta][s];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        if (RotaryCraft.instance.isLocked()) {
            return;
        }
        for (int j = 0; j <= 9; ++j) {
            for (int i = 0; i < 6; ++i) {
                this.icons[j][i] = par1IconRegister.func_94245_a("RotaryCraft:canola/" + j);
            }
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return 9;
    }

    public static void addFarmBlock(Block b) {
        BlockCanola.addFarmBlock(new BlockKey(b));
    }

    public static void addFarmBlock(Block b, int meta) {
        BlockCanola.addFarmBlock(new BlockKey(b, meta));
    }

    private static void addFarmBlock(BlockKey bk) {
        farmBlocks.add(bk);
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public ItemStack getWailaStack(IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaHead(ItemStack is, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaBody(ItemStack is, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        if (!currenttip.isEmpty()) {
            return currenttip;
        }
        int meta = acc.getMetadata();
        currenttip.add(String.format("Growth Stage: %d%s", 100 * meta / 9, "%"));
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaTail(ItemStack is, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean client) {
        return world.func_72805_g(x, y, z) < 9;
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        int to = Math.min(9, world.func_72805_g(x, y, z) + 1 + rand.nextInt(4));
        if (ModList.LEGACYCRAFT.isLoaded() && LegacyOptions.BONEMEAL.getState()) {
            to = 9;
        }
        world.func_72921_c(x, y, z, to, 3);
        world.func_72869_a("happyVillager", (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), 0.0, 0.0, 0.0);
    }

    public static boolean canSurvive(World world, int x, int y, int z) {
        return (world.func_72957_l(x, y, z) >= 6 || world.func_72937_j(x, y, z)) && BlockCanola.isValidFarmBlock(world, x, y - 1, z);
    }

    public static boolean canGrowAt(World world, int x, int y, int z) {
        return world.func_72957_l(x, y, z) >= 9 && BlockCanola.isValidFarmBlock(world, x, y - 1, z);
    }

    public static boolean isValidFarmBlock(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        if (id == Blocks.field_150350_a) {
            return false;
        }
        if (id == Blocks.field_150458_ak) {
            return world.func_72805_g(x, y, z) > 0;
        }
        return id.isFertile(world, x, y, z) && id.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)BlockRegistry.CANOLA.getBlockInstance());
    }

    public static ItemStack getDrops(int metadata, int fortune, Random rand) {
        int ndrops = 1;
        if (metadata == 9) {
            ndrops = BlockCanola.getDrops(fortune, rand);
        }
        ItemStack items = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.canolaSeeds, (int)ndrops);
        return items;
    }

    public static int getDrops(int fortune, Random rand) {
        int ndrops = Math.max(fortune * 2, (1 + rand.nextInt(2)) * (2 + rand.nextInt(8) + rand.nextInt(5)));
        if (fortune > 0) {
            ndrops = Math.max(ndrops, (int)((double)ndrops * rand.nextDouble() * (double)(1 + fortune)));
        }
        return ndrops;
    }

    public static float getPlantHeight(int meta) {
        return Math.max(0.125f, (float)meta / 9.0f);
    }
}

