/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileEntityProtectionDome
extends TileEntityPowerReceiver
implements RangedEffect,
GuiController {
    private int rgb;
    public int setRange;

    public abstract String getParticleType();

    public abstract int getFallOff();

    public abstract int getRangeBoost();

    protected void setColor(int r, int g, int b) {
        this.rgb = ReikaColorAPI.RGBtoHex((int)Math.min(255, r), (int)Math.min(255, g), (int)Math.min(255, b));
    }

    public final int getDomeColor() {
        return this.rgb;
    }

    protected final boolean isClear(World world, int x, int y, int z) {
        for (int i = 1; i <= this.setRange; ++i) {
            Block id = world.func_147439_a(x, y + i, z);
            if (id == Blocks.field_150350_a || id.getLightOpacity((IBlockAccess)world, x, y + i, z) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int getMaxRange() {
        int max;
        if (!this.isClear(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return 0;
        }
        if (this.power < this.MINPOWER) {
            return 0;
        }
        int range = 2 + (int)((this.power - this.MINPOWER) / (long)this.getFallOff()) + this.getRangeBoost();
        if (range > (max = Math.max(64, ConfigRegistry.FORCERANGE.getValue()))) {
            return max;
        }
        return range;
    }

    @SideOnly(value=Side.CLIENT)
    public final double func_145833_n() {
        return 16384.0;
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("setRange", this.setRange);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.setRange = NBT.func_74762_e("setRange");
    }

    protected final void spawnParticles(World world, int x, int y, int z) {
        for (int i = 0; i < 4; ++i) {
            world.func_72869_a(this.getParticleType(), (double)x + rand.nextDouble(), (double)y + rand.nextDouble() - 0.5, (double)z + rand.nextDouble(), rand.nextDouble() - 0.5, rand.nextDouble(), rand.nextDouble() - 0.5);
        }
    }

    protected final AxisAlignedBB getRangedBox() {
        int r = this.getRange();
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b((double)r, (double)r, (double)r);
    }

    @Override
    public final boolean hasModelTransparency() {
        return false;
    }

    @Override
    public final int getRange() {
        if (this.setRange > this.getMaxRange()) {
            return this.getMaxRange();
        }
        return this.setRange;
    }

    @Override
    public final void animateWithTick(World world, int x, int y, int z) {
    }

    public int getRedstoneOverride() {
        return 0;
    }
}

