/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.TileEntities.Piping.TileEntityPipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class SprinklerBlock
extends RotaryCraftTileEntity
implements PipeConnector,
RangedEffect {
    private int liquid;
    private int pressure;
    private StepTimer soundTimer = new StepTimer(40);

    private void getLiq(World world, int x, int y, int z, int metadata) {
        TileEntityPipe tile;
        int oldLevel = 0;
        ForgeDirection dir = this.getPipeDirection();
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        if (m != null && m.isStandardPipe() && (tile = (TileEntityPipe)world.func_147438_o(dx, dy, dz)) != null && tile.contains(FluidRegistry.WATER) && tile.getFluidLevel() > 0) {
            if (this.liquid < this.getCapacity()) {
                oldLevel = tile.getFluidLevel();
                int toremove = tile.getFluidLevel() / 4 + 1;
                int toadd = Math.min(toremove, this.getCapacity() - this.liquid);
                tile.removeLiquid(toadd);
                this.liquid = ReikaMathLibrary.extrema((int)(this.liquid + toadd), (int)0, (String)"max");
            }
            this.pressure = tile.getPressure();
        }
        if (this.liquid > this.getCapacity()) {
            this.liquid = this.getCapacity();
        }
    }

    public abstract int getCapacity();

    public abstract int getWaterConsumption();

    public abstract ForgeDirection getPipeDirection();

    public final void updateEntity(World world, int x, int y, int z, int meta) {
        this.getLiq(world, x, y, z, meta);
        if (this.canPerformEffects()) {
            this.performEffects(world, x, y, z);
            this.soundTimer.update();
            if (this.soundTimer.checkCap()) {
                SoundRegistry.SPRINKLER.playSoundAtBlock(world, x, y, z, 1.0f, 1.0f);
            }
            this.liquid -= this.getWaterConsumption();
        }
        this.doAnimations();
    }

    protected void doAnimations() {
    }

    public final boolean canPerformEffects() {
        return this.getRange() > 0 && this.liquid >= this.getWaterConsumption();
    }

    protected abstract void performEffects(World var1, int var2, int var3, int var4);

    public final int getWater() {
        return this.liquid;
    }

    public final int getPressure() {
        return this.pressure;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("press", this.pressure);
        NBT.func_74768_a("lvl", this.liquid);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.pressure = NBT.func_74762_e("press");
        this.liquid = NBT.func_74762_e("lvl");
        if (this.liquid < 0) {
            this.liquid = 0;
        }
        if (this.liquid > this.getCapacity()) {
            this.liquid = this.getCapacity();
        }
        if (this.pressure < 0) {
            this.pressure = 0;
        }
    }

    @Override
    public final int getRange() {
        int val = 0;
        if (this.pressure <= 0) {
            return 0;
        }
        val = this.pressure / 80;
        if (val > this.getMaxRange()) {
            val = this.getMaxRange();
        }
        return val;
    }

    @Override
    public final int getMaxRange() {
        return 8;
    }

    @Override
    public final boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public final boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side == this.getPipeDirection() ? p.isStandardPipe() : false;
    }

    @Override
    public final int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!resource.getFluid().equals(FluidRegistry.WATER)) {
            return 0;
        }
        int toadd = Math.min(resource.amount, this.getCapacity() - this.liquid);
        this.liquid += toadd;
        return toadd;
    }

    public boolean canFill(ForgeDirection side, Fluid f) {
        return f.equals(FluidRegistry.WATER) && side == this.getPipeDirection();
    }

    @Override
    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public final TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == this.getPipeDirection() ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }
}

