/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.ItemBasic;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryNames;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityACEngine;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBeltHub;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemMulti
extends ItemBasic {
    private int type;

    public ItemMulti(int par2type) {
        super(0);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.type = par2type;
        this.field_77777_bU = 64;
    }

    public ItemMulti(int par2type, int max) {
        super(0);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.type = par2type;
        this.field_77777_bU = max;
    }

    @Override
    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        if (super.func_77648_a(is, ep, world, x, y, z, s, a, b, c)) {
            return true;
        }
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, x, y, z);
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.compost)) {
            ItemDye.applyBonemeal((ItemStack)is, (World)world, (int)x, (int)y, (int)z, (EntityPlayer)ep);
        } else {
            if (this.isProperBelt(m, is)) {
                return this.tryBeltConnection(world, x, y, z, is, ep);
            }
            is.field_77990_d = null;
        }
        return false;
    }

    private boolean tryBeltConnection(World world, int x, int y, int z, ItemStack is, EntityPlayer ep) {
        TileEntityBeltHub te = (TileEntityBeltHub)world.func_147438_o(x, y, z);
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("ex", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("ey", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("ez", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("rx", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("ry", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("rz", Integer.MIN_VALUE);
        }
        if (te.isEmitting) {
            is.field_77990_d.func_74768_a("ex", x);
            is.field_77990_d.func_74768_a("ey", y);
            is.field_77990_d.func_74768_a("ez", z);
        } else {
            is.field_77990_d.func_74768_a("rx", x);
            is.field_77990_d.func_74768_a("ry", y);
            is.field_77990_d.func_74768_a("rz", z);
        }
        int ex = is.field_77990_d.func_74762_e("ex");
        int ey = is.field_77990_d.func_74762_e("ey");
        int ez = is.field_77990_d.func_74762_e("ez");
        int rx = is.field_77990_d.func_74762_e("rx");
        int ry = is.field_77990_d.func_74762_e("ry");
        int rz = is.field_77990_d.func_74762_e("rz");
        int dl = Math.abs(ex - rx + ey - ry + ez - rz) - 1;
        if ((is.field_77994_a >= dl || ep.field_71075_bZ.field_75098_d) && rx != Integer.MIN_VALUE && ry != Integer.MIN_VALUE && rz != Integer.MIN_VALUE && ex != Integer.MIN_VALUE && ey != Integer.MIN_VALUE && ez != Integer.MIN_VALUE) {
            TileEntityBeltHub em = (TileEntityBeltHub)world.func_147438_o(ex, ey, ez);
            TileEntityBeltHub rec = (TileEntityBeltHub)world.func_147438_o(rx, ry, rz);
            if (em == null) {
                ReikaChatHelper.writeString((String)("Belt Hub missing at " + ex + ", " + ey + ", " + ez));
                is.field_77990_d = null;
                return false;
            }
            if (rec == null) {
                ReikaChatHelper.writeString((String)("Belt Hub missing at " + rx + ", " + ry + ", " + rz));
                is.field_77990_d = null;
                return false;
            }
            rec.resetOther();
            em.resetOther();
            em.reset();
            rec.reset();
            boolean src = em.setSource(world, rx, ry, rz);
            boolean tg = rec.setTarget(world, ex, ey, ez);
            if (src && tg && !ep.field_71075_bZ.field_75098_d) {
                is.field_77994_a -= dl;
            }
            is.field_77990_d = null;
        }
        return false;
    }

    private boolean isProperBelt(MachineRegistry m, ItemStack is) {
        if (m == MachineRegistry.BELT && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.belt)) {
            return true;
        }
        return m == MachineRegistry.CHAIN && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.chain);
    }

    public void func_77663_a(ItemStack is, World world, Entity e, int par4, boolean par5) {
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.shaftcore) && is.field_77990_d != null) {
            int mag = is.field_77990_d.func_74762_e("magnet");
            if (mag > 0) {
                int x = (int)e.field_70165_t;
                int y = (int)e.field_70163_u;
                int z = (int)e.field_70161_v;
                for (int i = -6; i <= 6; ++i) {
                    for (int j = -6; j <= 6; ++j) {
                        for (int k = -6; k <= 6; ++k) {
                            if (!(world.func_147438_o(x + i, y + j, z + k) instanceof TileEntityACEngine)) continue;
                            TileEntityACEngine te = (TileEntityACEngine)world.func_147438_o(x + i, y + j, z + k);
                            double dx = (double)(x - te.field_145851_c) - 0.5;
                            double dy = (double)(y - te.field_145848_d) - 0.5;
                            double dz = (double)(z - te.field_145849_e) - 0.5;
                            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
                            double v = ReikaMathLibrary.py3d((double)e.field_70159_w, (double)e.field_70181_x, (double)e.field_70179_y);
                            te.magneticInterference(mag, dd);
                            te.soundtick = 1;
                        }
                    }
                }
            } else {
                is.field_77990_d.func_82580_o("magnet");
                if (is.field_77990_d.func_82582_d()) {
                    is.field_77990_d = null;
                }
            }
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List par3List, boolean par4) {
        if (is.field_77990_d == null) {
            return;
        }
        par3List.add("Additional Data Present.");
        if (is.field_77990_d.func_74764_b("magnet")) {
            if (is.field_77990_d.func_74762_e("magnet") >= 1000000) {
                par3List.add("Magnetized to " + String.format("%.3f", (double)is.field_77990_d.func_74762_e("magnet") / 1000000.0) + " T");
            } else if (is.field_77990_d.func_74762_e("magnet") >= 1000) {
                par3List.add("Magnetized to " + String.format("%.3f", (double)is.field_77990_d.func_74762_e("magnet") / 1000.0) + " mT");
            } else {
                par3List.add("Magnetized to " + is.field_77990_d.func_74762_e("magnet") + " microTeslas");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        int j;
        switch (this.type) {
            case 0: {
                j = RotaryNames.shaftPartNames.length;
                break;
            }
            case 1: {
                j = RotaryNames.enginePartNames.length;
                break;
            }
            case 2: {
                j = RotaryNames.miscPartNames.length;
                break;
            }
            case 3: {
                j = RotaryNames.borerPartNames.length;
                break;
            }
            case 4: {
                j = RotaryNames.extractNames.length;
                break;
            }
            case 6: {
                j = RotaryNames.compactNames.length;
                break;
            }
            case 7: {
                j = EngineType.engineList.length;
                break;
            }
            case 8: {
                j = RotaryNames.powderNames.length;
                break;
            }
            case 14: {
                j = RotaryNames.interfaceNames.length;
                break;
            }
            case 11: {
                j = RotaryNames.getNumberShaftTypes();
                break;
            }
            case 12: {
                j = RotaryNames.getNumberGearTypes();
                break;
            }
            case 23: {
                j = RotaryNames.gearUnitNames.length;
                break;
            }
            default: {
                j = 0;
            }
        }
        for (int i = 0; i < j; ++i) {
            ItemStack item = new ItemStack(par1, 1, i);
            if (ItemRegistry.GEARBOX.matchItem(item)) {
                if (item.field_77990_d == null) {
                    item.field_77990_d = new NBTTagCompound();
                }
                item.field_77990_d.func_74768_a("damage", 0);
            }
            if (ItemRegistry.COMPACTS.matchItem(item)) {
                par3List.add(item);
            } else {
                par3List.add(item);
            }
            if (!ReikaItemHelper.matchStacks((ItemStack)item, (ItemStack)ItemStacks.shaftcore)) continue;
            ItemStack mag = item.func_77946_l();
            if (DragonAPICore.isReikasComputer()) {
                mag.field_77990_d = new NBTTagCompound();
                mag.field_77990_d.func_74768_a("magnet", 32);
                par3List.add(mag);
                mag = item.func_77946_l();
                mag.field_77990_d = new NBTTagCompound();
                mag.field_77990_d.func_74768_a("magnet", 64000);
                par3List.add(mag);
                mag = item.func_77946_l();
            }
            mag.field_77990_d = new NBTTagCompound();
            mag.field_77990_d.func_74768_a("magnet", 0x1FFFFFFF);
            par3List.add(mag);
        }
    }

    public int func_77647_b(int damageValue) {
        return damageValue;
    }

    public String func_77667_c(ItemStack is) {
        int d = is.func_77960_j();
        String s = super.func_77658_a();
        switch (this.type) {
            case 0: {
                s = super.func_77658_a() + "." + RotaryNames.shaftPartNames[d];
                break;
            }
            case 1: {
                s = super.func_77658_a() + "." + RotaryNames.enginePartNames[d];
                break;
            }
            case 2: {
                s = super.func_77658_a() + "." + RotaryNames.miscPartNames[d];
                break;
            }
            case 3: {
                s = super.func_77658_a() + "." + RotaryNames.borerPartNames[d];
                break;
            }
            case 4: {
                s = super.func_77658_a() + "." + RotaryNames.extractNames[d];
                break;
            }
            case 6: {
                s = super.func_77658_a() + "." + RotaryNames.compactNames[d];
                break;
            }
            case 7: {
                s = super.func_77658_a() + "." + RotaryNames.getEngineName(d);
                break;
            }
            case 8: {
                s = super.func_77658_a() + "." + RotaryNames.powderNames[d];
                break;
            }
            case 10: {
                s = super.func_77658_a() + "." + RotaryNames.pipeNames[d];
                break;
            }
            case 11: {
                s = super.func_77658_a() + "." + RotaryNames.getShaftName(d);
                break;
            }
            case 12: {
                s = super.func_77658_a() + "." + RotaryNames.getGearboxName(d);
                break;
            }
            case 16: {
                s = super.func_77658_a() + "." + RotaryNames.interfaceNames[d];
                break;
            }
            case 23: {
                s = super.func_77658_a() + "." + RotaryNames.gearUnitNames[d];
            }
        }
        return ReikaStringParser.stripSpaces((String)s.toLowerCase(Locale.ENGLISH));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getItemSpriteIndex(ItemStack item) {
        int row = this.type % 16 + item.func_77960_j() / 16;
        if (ItemRegistry.EXTRACTS.matchItem(item) && item.func_77960_j() > 31) {
            return 144 + item.func_77960_j() - 32;
        }
        if (ItemRegistry.ENGINECRAFT.matchItem(item) && item.func_77960_j() >= 16) {
            row += 9;
        }
        if (ItemRegistry.POWDERS.matchItem(item) && item.func_77960_j() >= 16) {
            row += 3;
        }
        return 16 * row + item.func_77960_j() % 16;
    }
}

