/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TemperatureHandler {
    private static final BlockMap<Integer> blockTemps = new BlockMap();

    public static int getAmbientTemperature(World world, int x, int y, int z, int minAmb, int maxAmb) {
        return MathHelper.func_76125_a((int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z), (int)minAmb, (int)maxAmb);
    }

    public static int getAmbientTemperatureOffset(World world, int x, int y, int z, int temp, boolean allowHeating, boolean allowCooling) {
        return TemperatureHandler.getAmbientTemperatureOffset(world, x, y, z, temp, allowHeating ? EnumSet.allOf(ForgeDirection.class) : null, allowCooling ? EnumSet.allOf(ForgeDirection.class) : null);
    }

    public static int getAmbientTemperatureOffset(TemperatureTE te, Set<ForgeDirection> heatSides, Set<ForgeDirection> coolSides) {
        TileEntity tile = (TileEntity)te;
        return TemperatureHandler.getAmbientTemperatureOffset(tile.field_145850_b, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, te.getTemperature(), heatSides, coolSides);
    }

    public static int getAmbientTemperatureOffset(World world, int x, int y, int z, int temp, Set<ForgeDirection> heatSides, Set<ForgeDirection> coolSides) {
        int get;
        int ret = 0;
        if (heatSides != null) {
            for (ForgeDirection dir : heatSides) {
                get = TemperatureHandler.getBlockTemperature(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                if (get == Integer.MIN_VALUE || get <= temp) continue;
                ret += get - temp;
            }
        }
        if (coolSides != null) {
            for (ForgeDirection dir : coolSides) {
                get = TemperatureHandler.getBlockTemperature(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                if (get == Integer.MIN_VALUE || get >= temp) continue;
                ret -= temp - get;
            }
        }
        return ret;
    }

    private static int getBlockTemperature(World world, int x, int y, int z) {
        int meta;
        Block b = world.func_147439_a(x, y, z);
        Integer base = (Integer)blockTemps.get(b, meta = world.func_72805_g(x, y, z));
        if (base != null) {
            return base;
        }
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)b);
        if (f != null) {
            return f.getTemperature(world, x, y, z);
        }
        return Integer.MIN_VALUE;
    }

    public static void applyTemperature(TemperatureTE te) {
        TileEntity tile = (TileEntity)te;
        TemperatureHandler.applyTemperature(tile.field_145850_b, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, te.getTemperature());
    }

    public static void applyTemperature(World world, int x, int y, int z, int temp) {
    }

    static {
        blockTemps.put(Blocks.field_150353_l, (Object)600);
        blockTemps.put((Block)Blocks.field_150356_k, (Object)600);
        blockTemps.put((Block)Blocks.field_150480_ab, (Object)200);
        blockTemps.put(Blocks.field_150355_j, (Object)12);
        blockTemps.put((Block)Blocks.field_150358_i, (Object)12);
        blockTemps.put(Blocks.field_150432_aD, (Object)-3);
        blockTemps.put(Blocks.field_150403_cj, (Object)-10);
        blockTemps.put(Blocks.field_150433_aE, (Object)-2);
        blockTemps.put(Blocks.field_150431_aC, (Object)0);
    }
}

