/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.item.ItemStack;

public class RecipesFrictionHeater
extends RecipeHandler
implements RecipeInterface.FrictionHeaterManager {
    private static final RecipesFrictionHeater instance = new RecipesFrictionHeater();
    private final ItemHashMap<FrictionRecipe> recipes = new ItemHashMap();
    private final ItemHashMap<FrictionRecipe> outputs = new ItemHashMap();

    public static RecipesFrictionHeater getRecipes() {
        return instance;
    }

    private RecipesFrictionHeater() {
        super(MachineRegistry.FRICTION);
        RecipeInterface.friction = this;
        this.addRecipe(ItemStacks.tungstenflakes, ItemStacks.tungsteningot, 1350, 600, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(ItemStacks.silicondust, ItemStacks.silicon, 800, 200, RecipeHandler.RecipeLevel.PROTECTED);
    }

    private void addRecipe(ItemStack in, ItemStack out, int temp, int time, RecipeHandler.RecipeLevel rl) {
        FrictionRecipe rec = new FrictionRecipe(in, out, temp, time);
        this.recipes.put(in, (Object)rec);
        this.outputs.put(out, (Object)rec);
        this.onAddRecipe(rec, rl);
    }

    public void addCoreRecipe(ItemStack in, ItemStack out, int temp, int time) {
        this.addRecipe(in, out, temp, time, RecipeHandler.RecipeLevel.CORE);
    }

    @Override
    public void addAPIRecipe(ItemStack in, ItemStack out, int temp, int time) {
        this.addRecipe(in, out, temp, time, RecipeHandler.RecipeLevel.API);
    }

    public void addCustomRecipe(ItemStack in, ItemStack out, int temp, int time) {
        this.addRecipe(in, out, temp, time, RecipeHandler.RecipeLevel.CUSTOM);
    }

    public FrictionRecipe getSmelting(ItemStack in, int temperature) {
        FrictionRecipe rec = (FrictionRecipe)this.recipes.get(in);
        return rec != null ? (temperature >= rec.requiredTemperature ? rec : null) : null;
    }

    public FrictionRecipe getRecipeByOutput(ItemStack out) {
        return (FrictionRecipe)this.outputs.get(out);
    }

    public FrictionRecipe getRecipeByInput(ItemStack in) {
        return (FrictionRecipe)this.recipes.get(in);
    }

    public Collection<ItemStack> getAllSmeltables() {
        return Collections.unmodifiableCollection(this.recipes.keySet());
    }

    @Override
    public void addPostLoadRecipes() {
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipes.removeValue((Object)((FrictionRecipe)recipe)) && this.outputs.removeValue((Object)((FrictionRecipe)recipe));
    }

    @Override
    protected boolean addCustomRecipe(LuaBlock lb, CustomRecipeList crl) throws Exception {
        ItemStack in = crl.parseItemString(lb.getString("input"), null, false);
        ItemStack out = crl.parseItemString(lb.getString("output"), lb.getChild("output_nbt"), false);
        this.verifyOutputItem(out);
        this.addCustomRecipe(in, out, lb.getInt("temperature"), lb.getInt("duration"));
        return true;
    }

    public static final class FrictionRecipe
    implements RecipeHandler.MachineRecipe {
        public final int requiredTemperature;
        public final int duration;
        private final ItemStack input;
        private final ItemStack output;

        private FrictionRecipe(ItemStack in, ItemStack out, int temp, int time) {
            this.requiredTemperature = temp;
            this.duration = Math.abs(time);
            this.input = in;
            this.output = out;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        @Override
        public String getUniqueID() {
            return RecipeHandler.fullID(this.input) + ">" + RecipeHandler.fullID(this.output) + "@" + this.requiredTemperature + "#" + this.duration;
        }

        @Override
        public String getAllInfo() {
            return "Smelting " + RecipeHandler.fullID(this.input) + " into " + RecipeHandler.fullID(this.output) + " @ " + this.requiredTemperature + "C over " + this.duration + " ticks";
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            return ReikaJavaLibrary.makeListFrom((Object[])new ItemStack[]{this.input, this.output});
        }
    }
}

