/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.Auxiliary.CustomExtractLoader;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.ExtractorModOres;
import Reika.RotaryCraft.ModInterface.ItemCustomModOre;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RecipesExtractor {
    private static final RecipesExtractor instance = new RecipesExtractor();
    private final ItemHashMap<ItemStack> recipeList = new ItemHashMap().setOneWay();

    public static final RecipesExtractor getRecipes() {
        return instance;
    }

    private RecipesExtractor() {
        for (int i = 0; i < 24; ++i) {
            this.addRecipe(ItemRegistry.EXTRACTS.getStackOfMetadata(i), ItemRegistry.EXTRACTS.getStackOfMetadata(i + 8));
        }
        this.addRecipe(Blocks.field_150365_q, 0, ItemStacks.getDust(ReikaOreHelper.COAL));
        this.addRecipe(Blocks.field_150366_p, 0, ItemStacks.getDust(ReikaOreHelper.IRON));
        this.addRecipe(Blocks.field_150352_o, 0, ItemStacks.getDust(ReikaOreHelper.GOLD));
        this.addRecipe(Blocks.field_150450_ax, 0, ItemStacks.getDust(ReikaOreHelper.REDSTONE));
        this.addRecipe(Blocks.field_150369_x, 0, ItemStacks.getDust(ReikaOreHelper.LAPIS));
        this.addRecipe(Blocks.field_150482_ag, 0, ItemStacks.getDust(ReikaOreHelper.DIAMOND));
        this.addRecipe(Blocks.field_150412_bA, 0, ItemStacks.getDust(ReikaOreHelper.EMERALD));
        this.addRecipe(Blocks.field_150449_bY, 0, ItemStacks.getDust(ReikaOreHelper.QUARTZ));
        this.addModRecipes();
    }

    private void addModRecipes() {
        for (int i = 0; i < ModOreList.oreList.length; ++i) {
            ModOreList ore = ModOreList.oreList[i];
            Collection c = ore.getAllOreBlocks();
            for (ItemStack is : c) {
                if (this.recipeList.containsKey(is)) {
                    ModOreList mod = (ModOreList)ExtractorModOres.getOreFromExtract((ItemStack)this.recipeList.get(is));
                    RotaryCraft.logger.log((Object)("Ore " + is.func_82833_r() + " is being skipped for Extractor registration as " + ore + " as it is already registered to " + mod));
                    continue;
                }
                this.addRecipe(is, ExtractorModOres.getDustProduct(ore));
            }
            this.addRecipe(ExtractorModOres.getDustProduct(ore), ExtractorModOres.getSlurryProduct(ore));
            this.addRecipe(ExtractorModOres.getSlurryProduct(ore), ExtractorModOres.getSolutionProduct(ore));
            this.addRecipe(ExtractorModOres.getSolutionProduct(ore), ExtractorModOres.getFlakeProduct(ore));
        }
        List<CustomExtractLoader.CustomExtractEntry> li = CustomExtractLoader.instance.getEntries();
        for (int i = 0; i < li.size(); ++i) {
            CustomExtractLoader.CustomExtractEntry e = li.get(i);
            Collection<ItemStack> c = e.getAllOreBlocks();
            for (ItemStack is : c) {
                if (this.recipeList.containsKey(is)) {
                    RotaryCraft.logger.log((Object)("Ore " + is.func_82833_r() + " is being skipped for Extractor registration as " + e + " as it is already registered to " + this.recipeList.get(is)));
                    continue;
                }
                this.addRecipe(is, ItemCustomModOre.getItem(i, ExtractorModOres.ExtractorStage.DUST));
            }
            this.addRecipe(ItemCustomModOre.getItem(i, ExtractorModOres.ExtractorStage.DUST), ItemCustomModOre.getItem(i, ExtractorModOres.ExtractorStage.SLURRY));
            this.addRecipe(ItemCustomModOre.getItem(i, ExtractorModOres.ExtractorStage.SLURRY), ItemCustomModOre.getItem(i, ExtractorModOres.ExtractorStage.SOLUTION));
            this.addRecipe(ItemCustomModOre.getItem(i, ExtractorModOres.ExtractorStage.SOLUTION), ItemCustomModOre.getItem(i, ExtractorModOres.ExtractorStage.FLAKES));
        }
    }

    private void addRecipe(Block in, ItemStack out) {
        this.addRecipe(new ItemStack(in), out);
    }

    private void addRecipe(Block in, int meta, ItemStack out) {
        this.addRecipe(new ItemStack(in, 1, meta), out);
    }

    private void addRecipe(Item in, ItemStack out) {
        this.addRecipe(new ItemStack(in), out);
    }

    private void addRecipe(Item in, int dmg, ItemStack out) {
        this.addRecipe(new ItemStack(in, 1, dmg), out);
    }

    private void addRecipe(ItemStack in, ItemStack out) {
        this.recipeList.put(in, (Object)out);
    }

    public ItemStack getExtractionResult(ItemStack item) {
        ItemStack ret;
        if (item == null) {
            return null;
        }
        ReikaOreHelper ore = ReikaOreHelper.getEntryByOreDict((ItemStack)item);
        if (ore != null) {
            item = ore.getOreBlock();
        }
        return (ret = (ItemStack)this.recipeList.get(item)) != null ? ret.func_77946_l() : null;
    }

    public static boolean isDust(ItemStack is) {
        if (!ItemRegistry.EXTRACTS.matchItem(is)) {
            return false;
        }
        int dmg = is.func_77960_j();
        return dmg < ReikaOreHelper.oreList.length;
    }

    public static boolean isSlurry(ItemStack is) {
        if (!ItemRegistry.EXTRACTS.matchItem(is)) {
            return false;
        }
        int dmg = is.func_77960_j();
        return dmg < ReikaOreHelper.oreList.length * 2 && dmg >= ReikaOreHelper.oreList.length;
    }

    public static boolean isSolution(ItemStack is) {
        if (!ItemRegistry.EXTRACTS.matchItem(is)) {
            return false;
        }
        int dmg = is.func_77960_j();
        return dmg < ReikaOreHelper.oreList.length * 3 && dmg >= ReikaOreHelper.oreList.length * 2;
    }

    public static boolean isFlakes(ItemStack is) {
        if (!ItemRegistry.EXTRACTS.matchItem(is)) {
            return false;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.silverflakes) || ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.tungstenflakes)) {
            return true;
        }
        int dmg = is.func_77960_j();
        return dmg < ReikaOreHelper.oreList.length * 4 && dmg >= ReikaOreHelper.oreList.length * 3;
    }

    public static ReikaOreHelper getOreFromExtract(ItemStack item) {
        return ReikaOreHelper.oreList[item.func_77960_j() % ReikaOreHelper.oreList.length];
    }
}

