/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.API.TreeGetter;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Registry.PlantMaterials;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MulchMaterials {
    public static final MulchMaterials instance = new MulchMaterials();
    private final ItemHashMap<Integer> values = new ItemHashMap().setOneWay();

    private MulchMaterials() {
        int i;
        if (ModList.CHROMATICRAFT.isLoaded()) {
            for (i = 0; i < 16; ++i) {
                this.addValue(TreeGetter.getDyeSapling((int)i), PlantMaterials.SAPLING.getPlantValue());
                this.addValue(TreeGetter.getHeldDyeLeaf((int)i), PlantMaterials.LEAVES.getPlantValue());
                this.addValue(TreeGetter.getDyeFlower((int)i), PlantMaterials.FLOWER.getPlantValue());
            }
            this.addValue(TreeGetter.getRainbowLeaf(), 16);
            this.addValue(TreeGetter.getRainbowSapling(), 8);
        }
        if (ModList.FORESTRY.isLoaded()) {
            this.addValue(ForestryHandler.ItemEntry.SAPLING.getItem(), 2);
            this.addValue(ForestryHandler.ItemEntry.HONEY.getItem(), 1);
            this.addValue(ForestryHandler.ItemEntry.HONEYDEW.getItem(), 1);
            this.addValue(ForestryHandler.BlockEntry.LEAF.getBlock(), 4);
        }
        if (ModList.EMASHER.isLoaded()) {
            this.addValue(ModCropList.ALGAE.blockID, 3);
        }
        if (ModList.BOTANIA.isLoaded()) {
            Item petal = GameRegistry.findItem((String)ModList.BOTANIA.modLabel, (String)"petal");
            Block flower = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"flower");
            Block tallflower1 = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"doubleFlower1");
            Block tallflower2 = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"doubleFlower2");
            for (int i2 = 0; i2 < 16; ++i2) {
                Block tall = i2 >= 8 ? tallflower2 : tallflower1;
                int tallm = i2 % 8;
                this.addValue(new ItemStack(flower, 1, i2), 4);
                this.addValue(new ItemStack(tall, 1, tallm), 8);
                this.addValue(new ItemStack(petal, 1, i2), 2);
            }
        }
        for (i = 0; i < ModWoodList.woodList.length; ++i) {
            ModWoodList wood = ModWoodList.woodList[i];
            if (!wood.exists()) continue;
            this.addValue(wood.getCorrespondingSapling(), PlantMaterials.SAPLING.getPlantValue() * this.getModWoodValue(wood));
            for (ItemStack leaf : wood.getAllLeaves()) {
                if (leaf == null || leaf.func_77973_b() == null) {
                    RotaryCraft.logger.logError((Object)("Tried to add mulch recipe for a stack (" + wood + " leaves) which does not exist!"));
                    continue;
                }
                if (this.values.containsKey(leaf)) continue;
                this.addValue(leaf, PlantMaterials.LEAVES.getPlantValue() * this.getModWoodValue(wood));
            }
        }
        for (i = 0; i < PlantMaterials.plantList.length; ++i) {
            PlantMaterials plant = PlantMaterials.plantList[i];
            int[] metas = plant.getMetadatas();
            for (int k = 0; k < metas.length; ++k) {
                ItemStack is = plant.getPlantItem();
                is.func_77964_b(metas[k]);
                this.addValue(is, plant.getPlantValue());
            }
        }
        this.addValue(ItemStacks.sawdust.func_77946_l(), 1);
    }

    private void addValue(Item i, int amt) {
        this.addValue(new ItemStack(i), amt);
    }

    private void addValue(Block i, int amt) {
        this.addValue(new ItemStack(i), amt);
    }

    private void addValue(ItemStack is, int amt) {
        if (is == null || is.func_77973_b() == null) {
            RotaryCraft.logger.logError((Object)"Tried to add mulch recipe for a stack which does not exist!");
            Thread.dumpStack();
            return;
        }
        if (amt <= 0) {
            RotaryCraft.logger.logError((Object)("Tried to add mulch recipe for " + is + " (" + is.func_82833_r() + ") that produces zero sludge?!"));
            return;
        }
        this.values.put(is, (Object)amt);
    }

    public Collection<ItemStack> getAllValidPlants() {
        return this.values.keySet();
    }

    public boolean isMulchable(ItemStack is) {
        return this.values.containsKey(is);
    }

    public int getPlantValue(ItemStack is) {
        Integer ret = (Integer)this.values.get(is);
        return ret != null ? ret : 0;
    }

    private int getModWoodValue(ModWoodList wood) {
        if (wood == null) {
            return 0;
        }
        if (wood.isRareTree()) {
            return 32;
        }
        if (wood == ModWoodList.LIGHTED) {
            return 12;
        }
        ModList mod = wood.getParentMod();
        if (mod == ModList.THAUMCRAFT) {
            return 4;
        }
        if (mod == ModList.TWILIGHT) {
            return 3;
        }
        return 1;
    }
}

