/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.Auxiliary.CustomExtractLoader;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.AutoOreItem;
import Reika.RotaryCraft.ModInterface.ItemCustomModOre;
import Reika.RotaryCraft.Registry.ItemRegistry;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ExtractorModOres {
    public static void registerRCIngots() {
        for (int i = 0; i < ModOreList.oreList.length; ++i) {
            OreDictionary.registerOre((String)ModOreList.oreList[i].getProductOreDictName(), (ItemStack)ItemRegistry.MODINGOTS.getStackOfMetadata(i));
        }
        OreDictionary.registerOre((String)"ingotHeeEndium", (ItemStack)ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.ENDIUM.ordinal()));
        List<CustomExtractLoader.CustomExtractEntry> li = CustomExtractLoader.instance.getEntries();
        for (int i = 0; i < li.size(); ++i) {
            CustomExtractLoader.CustomExtractEntry e = li.get(i);
            OreType nat = e.nativeOre;
            if (nat != null) continue;
            ItemStack out = ItemCustomModOre.getSmeltedItem(i);
            OreDictionary.registerOre((String)e.productName, (ItemStack)out);
        }
    }

    public static void addSmelting() {
        for (int i = 0; i < ModOreList.oreList.length; ++i) {
            ModOreList ore = ModOreList.oreList[i];
            ItemStack in = ItemRegistry.MODEXTRACTS.getStackOfMetadata(ExtractorModOres.getFlakesIndex(ore));
            ItemStack out = ReikaItemHelper.getSizedItemStack((ItemStack)ExtractorModOres.getSmeltedIngot(ore), (int)ore.getDropCount());
            ReikaRecipeHelper.addSmelting((ItemStack)in, (ItemStack)out, (float)(ore.rarity == OreType.OreRarity.RARE ? 1.0f : (ore.rarity == OreType.OreRarity.EVERYWHERE ? 0.5f : 0.7f)));
        }
    }

    public static void addCustomSmelting() {
        List<CustomExtractLoader.CustomExtractEntry> li = CustomExtractLoader.instance.getEntries();
        for (int i = 0; i < li.size(); ++i) {
            CustomExtractLoader.CustomExtractEntry e = li.get(i);
            ItemStack in = ItemCustomModOre.getItem(i, ExtractorStage.FLAKES);
            OreType nat = e.nativeOre;
            ItemStack out = ItemCustomModOre.getSmeltedItem(i);
            out.field_77994_a = e.numberSmelted;
            if (nat instanceof ReikaOreHelper) {
                out = ((ReikaOreHelper)nat).getDrop();
                out.field_77994_a = ((ReikaOreHelper)nat).blockDrops;
            } else if (nat instanceof ModOreList) {
                out = ExtractorModOres.getSmeltedIngot((ModOreList)nat);
                out.field_77994_a = ((ModOreList)nat).dropCount;
            }
            ReikaRecipeHelper.addSmelting((ItemStack)in, (ItemStack)out, (float)(e.rarity == OreType.OreRarity.RARE ? 1.0f : (e.rarity == OreType.OreRarity.EVERYWHERE ? 0.5f : 0.7f)));
        }
    }

    public static int getSpritesheet(ModOreList ore) {
        return ore.ordinal() / 64;
    }

    public static boolean isModOreIngredient(ItemStack is) {
        if (is == null) {
            return false;
        }
        if (!ItemRegistry.MODEXTRACTS.matchItem(is)) {
            return false;
        }
        return ModOreList.getEntryFromDamage((int)(is.func_77960_j() / 4)) != null;
    }

    public static ExtractorStage getStageFromMetadata(ItemStack is) {
        return ExtractorStage.list[is.func_77960_j() % 4];
    }

    public static int getIndexOffsetForIngot(ItemStack is) {
        ModOreList ore = ModOreList.getEntryFromDamage((int)is.func_77960_j());
        if (ore.isIngotType()) {
            return 3;
        }
        if (ore.isDustType()) {
            return 1;
        }
        if (ore.isGemType()) {
            return 2;
        }
        return 0;
    }

    public static int getDustIndex(ModOreList ore) {
        return ore.ordinal() * 4;
    }

    public static int getSlurryIndex(ModOreList ore) {
        return ExtractorModOres.getDustIndex(ore) + 1;
    }

    public static int getSolutionIndex(ModOreList ore) {
        return ExtractorModOres.getDustIndex(ore) + 2;
    }

    public static int getFlakesIndex(ModOreList ore) {
        return ExtractorModOres.getDustIndex(ore) + 3;
    }

    public static boolean isDust(ModOreList ore, int index) {
        return index == ExtractorModOres.getDustIndex(ore);
    }

    public static boolean isSlurry(ModOreList ore, int index) {
        return index == ExtractorModOres.getSlurryIndex(ore);
    }

    public static boolean isSolution(ModOreList ore, int index) {
        return index == ExtractorModOres.getSolutionIndex(ore);
    }

    public static boolean isFlakes(ModOreList ore, int index) {
        return index == ExtractorModOres.getFlakesIndex(ore);
    }

    public static ItemStack getDustProduct(ModOreList ore) {
        return ItemRegistry.MODEXTRACTS.getStackOfMetadata(ExtractorModOres.getDustIndex(ore));
    }

    public static ItemStack getSlurryProduct(ModOreList ore) {
        return ItemRegistry.MODEXTRACTS.getStackOfMetadata(ExtractorModOres.getSlurryIndex(ore));
    }

    public static ItemStack getSolutionProduct(ModOreList ore) {
        return ItemRegistry.MODEXTRACTS.getStackOfMetadata(ExtractorModOres.getSolutionIndex(ore));
    }

    public static ItemStack getFlakeProduct(ModOreList ore) {
        return ItemRegistry.MODEXTRACTS.getStackOfMetadata(ExtractorModOres.getFlakesIndex(ore));
    }

    public static boolean isOreFlake(ItemStack is) {
        if (ItemRegistry.EXTRACTS.matchItem(is)) {
            return ReikaMathLibrary.isValueInsideBoundsIncl((int)ItemStacks.coaloreflakes.func_77960_j(), (int)ItemStacks.tungstenflakes.func_77960_j(), (int)is.func_77960_j());
        }
        if (ItemRegistry.MODEXTRACTS.matchItem(is)) {
            return is.func_77960_j() % 4 == 3;
        }
        if (ItemRegistry.CUSTOMEXTRACT.matchItem(is)) {
            return is.func_77960_j() % 4 == 3;
        }
        return false;
    }

    public static OreType getOreFromExtract(ItemStack is) {
        if (is.func_77973_b() instanceof AutoOreItem) {
            return ((AutoOreItem)is.func_77973_b()).getOreType(is);
        }
        if (ItemRegistry.EXTRACTS.matchItem(is)) {
            return ReikaOreHelper.oreList[is.func_77960_j() % ReikaOreHelper.oreList.length];
        }
        if (ItemRegistry.MODEXTRACTS.matchItem(is)) {
            return ModOreList.oreList[is.func_77960_j() / 4];
        }
        return null;
    }

    public static ItemStack getSmeltedIngot(ModOreList ore) {
        switch (ore) {
            case NETHERCOAL: {
                return new ItemStack(Items.field_151044_h);
            }
            case NETHERCOPPER: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.COPPER.ordinal());
            }
            case NETHERDIAMOND: {
                return new ItemStack(Items.field_151045_i);
            }
            case NETHEREMERALD: {
                return new ItemStack(Items.field_151166_bC);
            }
            case NETHERGOLD: {
                return new ItemStack(Items.field_151043_k);
            }
            case NETHERIRON: {
                return new ItemStack(Items.field_151042_j);
            }
            case NETHERLAPIS: {
                return ReikaItemHelper.lapisDye.func_77946_l();
            }
            case NETHERLEAD: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.LEAD.ordinal());
            }
            case NETHERNICKEL: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.NICKEL.ordinal());
            }
            case NETHERNIKOLITE: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.NIKOLITE.ordinal());
            }
            case NETHERREDSTONE: {
                return new ItemStack(Items.field_151137_ax);
            }
            case NETHERSILVER: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.SILVER.ordinal());
            }
            case NETHERTIN: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.TIN.ordinal());
            }
            case NETHERPLATINUM: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.PLATINUM.ordinal());
            }
            case NETHERURANIUM: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.URANIUM.ordinal());
            }
            case NETHERIRIDIUM: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.IRIDIUM.ordinal());
            }
            case NETHERSULFUR: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.SULFUR.ordinal());
            }
            case NETHERTITANIUM: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.TITANIUM.ordinal());
            }
            case NETHEROSMIUM: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.OSMIUM.ordinal());
            }
            case NETHERSALTPETER: {
                return ItemRegistry.MODINGOTS.getStackOfMetadata(ModOreList.SALTPETER.ordinal());
            }
        }
        return ItemRegistry.MODINGOTS.getStackOfMetadata(ore.ordinal());
    }

    public static enum ExtractorStage {
        DUST,
        SLURRY,
        SOLUTION,
        FLAKES;

        private static final ExtractorStage[] list;

        static {
            list = ExtractorStage.values();
        }
    }
}

