/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Effects.LightningBolt;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EMPSparkRenderer {
    public static final EMPSparkRenderer instance = new EMPSparkRenderer();
    private static final int SPARK_COUNT = 4;
    private static final Random rand = new Random();
    private ArrayList<EMPSpark> sparks = new ArrayList();
    private final HashSet<WorldLocation> locations = new HashSet();
    private final ArrayList<WorldLocation> selectableLocations = new ArrayList();

    private EMPSparkRenderer() {
    }

    public void addSparkingLocation(WorldLocation loc) {
        if (!this.selectableLocations.contains(loc)) {
            this.selectableLocations.add(loc);
        }
    }

    public void removeSparkingLocation(WorldLocation loc) {
        this.selectableLocations.remove(loc);
    }

    public void tick() {
        WorldLocation loc;
        Iterator<EMPSpark> it = this.sparks.iterator();
        while (it.hasNext()) {
            EMPSpark sp = it.next();
            if (!sp.tick()) continue;
            it.remove();
            this.locations.remove(sp.location);
        }
        if (!this.selectableLocations.isEmpty() && this.sparks.size() < 4 && rand.nextInt(4) == 0 && (loc = this.selectableLocations.get(rand.nextInt(this.selectableLocations.size()))) != null) {
            this.doAddLocation(loc);
        }
    }

    private void doAddLocation(WorldLocation loc) {
        if (loc != null && !this.locations.contains(loc)) {
            this.sparks.add(new EMPSpark(loc));
            this.locations.add(loc);
        }
    }

    public void render(Tessellator v5, float ptick) {
        GL11.glPushAttrib((int)1048575);
        ReikaRenderHelper.prepareGeoDraw((boolean)true);
        ReikaRenderHelper.disableEntityLighting();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
        for (EMPSpark sp : this.sparks) {
            if (((EMPSpark)sp).location.dimensionID != Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g) continue;
            sp.render(v5, ptick);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static class EMPSpark {
        private final WorldLocation location;
        private final int LIFESPAN;
        private final Collection<LightningBolt> bolts = new ArrayList<LightningBolt>();
        private final Interpolation brightnessCurve = new Interpolation(false);
        private int age = 0;

        private EMPSpark(WorldLocation loc) {
            int a;
            this.location = loc;
            int n = 1 + rand.nextInt(4);
            for (int i = 0; i < n; ++i) {
                this.bolts.add(this.createBolt());
            }
            this.LIFESPAN = 8 + rand.nextInt(40);
            double f = 0.5 + 0.5 * rand.nextDouble();
            this.brightnessCurve.addPoint((double)a, f);
            for (a = 0; a < this.LIFESPAN; a += Math.min(this.LIFESPAN - a, ReikaRandomHelper.getRandomBetween((int)4, (int)10))) {
                f = rand.nextDouble();
                this.brightnessCurve.addPoint((double)a, f);
            }
        }

        private LightningBolt createBolt() {
            double o = 0.0625;
            double r = 0.5 + o;
            double x1 = -o + rand.nextDouble() * (1.0 + o * 2.0);
            double y1 = -o + rand.nextDouble() * (1.0 + o * 2.0);
            double z1 = -o + rand.nextDouble() * (1.0 + o * 2.0);
            double x2 = -o + rand.nextDouble() * (1.0 + o * 2.0);
            double y2 = -o + rand.nextDouble() * (1.0 + o * 2.0);
            double z2 = -o + rand.nextDouble() * (1.0 + o * 2.0);
            switch (ForgeDirection.VALID_DIRECTIONS[rand.nextInt(6)]) {
                case DOWN: {
                    y1 = y2 = -o;
                    break;
                }
                case UP: {
                    y1 = y2 = o;
                    break;
                }
                case EAST: {
                    x1 = x2 = o;
                    break;
                }
                case WEST: {
                    x1 = x2 = -o;
                    break;
                }
                case NORTH: {
                    z1 = z2 = -o;
                    break;
                }
                case SOUTH: {
                    z1 = z2 = o;
                    break;
                }
            }
            LightningBolt bolt = new LightningBolt(x1 += (double)this.location.xCoord, y1 += (double)this.location.yCoord, z1 += (double)this.location.zCoord, x2 += (double)this.location.xCoord, y2 += (double)this.location.yCoord, z2 += (double)this.location.zCoord, 6);
            bolt.velocity /= 64.0;
            bolt.variance /= 12.0;
            return bolt;
        }

        public void render(Tessellator v5, float ptick) {
            double f = this.brightnessCurve.getValue((double)this.age);
            for (LightningBolt bolt : this.bolts) {
                float w = GL11.glGetFloat((int)2849);
                GL11.glLineWidth((float)4.0f);
                this.drawBolt(bolt, v5, 0x7000FFFF, f);
                GL11.glLineWidth((float)w);
                this.drawBolt(bolt, v5, -1, f);
                bolt.update();
            }
        }

        private void drawBolt(LightningBolt bolt, Tessellator v5, int color, double brightness) {
            v5.func_78371_b(3);
            v5.func_78384_a(color & 0xFFFFFF, (int)(brightness * (double)ReikaColorAPI.getAlpha((int)color)));
            for (int i = 0; i < bolt.nsteps; ++i) {
                DecimalPosition p = bolt.getPosition(i);
                v5.func_78377_a(p.xCoord, p.yCoord, p.zCoord);
            }
            v5.func_78381_a();
        }

        private boolean tick() {
            ++this.age;
            return this.age >= this.LIFESPAN;
        }
    }
}

