/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.ElectriCraft.API.WrappableWireSource;
import Reika.ElectriCraft.Auxiliary.Interfaces.Overloadable;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireEmitter;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireReceiver;
import Reika.ElectriCraft.Auxiliary.WrappedSource;
import Reika.ElectriCraft.Base.WiringTile;
import Reika.ElectriCraft.Blocks.BlockWire;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.ElectriCraft.Registry.WireType;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWire
extends WiringTile
implements Overloadable {
    private boolean[] connections = new boolean[6];
    public boolean insulated;
    private boolean shouldMelt;

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.shouldMelt) {
            this.melt(world, x, y, z);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public ElectriTiles getMachine() {
        return ElectriTiles.WIRE;
    }

    @Override
    protected void onJoinNetwork() {
        this.checkForWrappables();
    }

    @Override
    public void onNetworkChanged() {
        super.onNetworkChanged();
        this.checkForWrappables();
    }

    public boolean isConnectedOnSideAt(World world, int x, int y, int z, ForgeDirection dir) {
        dir = dir.offsetX == 0 ? dir.getOpposite() : dir;
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        Block b = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        TileEntity te = world.func_147438_o(dx, dy, dz);
        if (b == this.getTileEntityBlockID()) {
            return true;
        }
        boolean flag = false;
        if (te instanceof WiringTile) {
            boolean bl = flag = flag || ((WiringTile)te).canNetworkOnSide(dir.getOpposite());
        }
        if (te instanceof WireEmitter) {
            boolean bl = flag = flag || ((WireEmitter)te).canEmitPowerToSide(dir.getOpposite());
        }
        if (te instanceof WireReceiver) {
            boolean bl = flag = flag || ((WireReceiver)te).canReceivePowerFromSide(dir.getOpposite());
        }
        if (te instanceof WorldRift) {
            flag = true;
        }
        if (te instanceof WrappableWireSource) {
            flag = flag || ((WrappableWireSource)te).canConnectToSide(dir.getOpposite());
        }
        return flag;
    }

    @Override
    public final boolean canNetworkOnSide(ForgeDirection dir) {
        return true;
    }

    public WireType getWireType() {
        int meta = this.isInWorld() ? this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) : this.func_145832_p();
        return WireType.wireList[meta];
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.connections = ReikaArrayHelper.booleanFromByteBitflags((byte)NBT.func_74771_c("conn"), (int)6);
        this.insulated = NBT.func_74767_n("insul");
        this.shouldMelt = NBT.func_74767_n("melt");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74774_a("conn", ReikaArrayHelper.booleanToByteBitflags((boolean[])this.connections));
        NBT.func_74757_a("insul", this.insulated);
        NBT.func_74757_a("melt", this.shouldMelt);
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public boolean isConnectionValidForSide(ForgeDirection dir) {
        if (dir.offsetX == 0 && MinecraftForgeClient.getRenderPass() != 1) {
            dir = dir.getOpposite();
        }
        return this.connections[dir.ordinal()];
    }

    public void recomputeConnections(World world, int x, int y, int z) {
        boolean clear = false;
        for (int i = 0; i < 6; ++i) {
            boolean flag = this.isConnected(this.dirs[i]);
            if (flag != this.connections[i]) {
                clear = true;
            }
            this.connections[i] = flag;
            world.func_147479_m(x + this.dirs[i].offsetX, y + this.dirs[i].offsetY, z + this.dirs[i].offsetZ);
        }
        this.checkForWrappables();
        world.func_147479_m(x, y, z);
        if (clear && this.network != null) {
            this.network.removeElement(this);
        }
    }

    public void checkRiftConnections() {
        if (this.network != null) {
            this.network.checkRiftConnections();
        }
    }

    private void checkForWrappables() {
        if (this.network == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
            if (!(te instanceof WrappableWireSource)) continue;
            this.network.addElement(new WrappedSource((WrappableWireSource)te));
        }
    }

    public void addToAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            ElectriTiles m = ElectriTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (m != this.getMachine()) continue;
            TileEntityWire te = (TileEntityWire)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = true;
            world.func_147479_m(dx, dy, dz);
        }
    }

    private boolean isConnected(ForgeDirection dir) {
        ElectriTiles m2;
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY;
        int z = this.field_145849_e + dir.offsetZ;
        ElectriTiles m = this.getMachine();
        return m == (m2 = ElectriTiles.getTE((IBlockAccess)this.field_145850_b, x, y, z));
    }

    @Override
    public int getMaxCurrent() {
        return this.getWireType().maxCurrent;
    }

    public void melt(World world, int x, int y, int z) {
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
        ReikaParticleHelper.LAVA.spawnAroundBlock(world, x, y, z, 12);
        world.func_147449_b(x, y, z, (Block)Blocks.field_150356_k);
    }

    @Override
    public void overload(int current) {
        this.shouldMelt = true;
    }

    public IIcon getEndIcon() {
        return BlockWire.getEndTexture(this.getWireType());
    }

    public IIcon getCenterIcon() {
        return BlockWire.getTexture(this.getWireType());
    }

    public IIcon getInsulatedCenterIcon() {
        return BlockWire.getInsulatedTexture(this.getWireType());
    }

    public IIcon getInsulatedEndIcon() {
        return BlockWire.getInsulatedEndTexture(this.getWireType());
    }

    @Override
    public int getResistance() {
        return this.getWireType().resistance;
    }
}

