/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.ElectriCraft.Auxiliary.Interfaces.CurrentThrottle;
import Reika.ElectriCraft.Base.TileEntityWireComponent;
import Reika.ElectriCraft.Registry.ElectriTiles;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityResistor
extends TileEntityWireComponent
implements CurrentThrottle {
    private int selectedCurrent;
    private ColorBand b1 = ColorBand.BLACK;
    private ColorBand b2 = ColorBand.BLACK;
    private ColorBand b3 = ColorBand.BLACK;

    public ReikaDyeHelper[] getBandRenderColors() {
        return new ReikaDyeHelper[]{this.b1.renderColor, this.b2.renderColor, this.b3.renderColor};
    }

    @Override
    public int getResistance() {
        return 0;
    }

    @Override
    public int getCurrentLimit() {
        return this.selectedCurrent;
    }

    public boolean setColor(ReikaDyeHelper color, int digit) {
        ColorBand band;
        ColorBand colorBand = band = color != null ? ColorBand.getBandFromColor(color) : null;
        if (band == null) {
            return false;
        }
        if (band.ordinal() > 7 && digit == 3) {
            return false;
        }
        if (digit == 1) {
            this.b1 = band;
        }
        if (digit == 2) {
            this.b2 = band;
        }
        if (digit == 3) {
            this.b3 = band;
        }
        this.selectedCurrent = this.calculateCurrentLimit(this.b1, this.b2, this.b3);
        if (!this.field_145850_b.field_72995_K && this.network != null) {
            this.network.updateWires();
        }
        return true;
    }

    private int calculateCurrentLimit(ColorBand b1, ColorBand b2, ColorBand b3) {
        int digit1 = b1.ordinal();
        int digit2 = b2.ordinal();
        int multiplier = b3.ordinal();
        int base = Integer.parseInt(String.format("%d%d", digit1, digit2));
        return base * ReikaMathLibrary.intpow2((int)10, (int)multiplier);
    }

    @Override
    public ElectriTiles getMachine() {
        return ElectriTiles.RESISTOR;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void onNetworkChanged() {
    }

    @Override
    public void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.b1 = ColorBand.bandList[NBT.func_74762_e("band1")];
        this.b2 = ColorBand.bandList[NBT.func_74762_e("band2")];
        this.b3 = ColorBand.bandList[NBT.func_74762_e("band3")];
        this.selectedCurrent = NBT.func_74762_e("sel");
    }

    @Override
    public void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("band1", this.b1.ordinal());
        NBT.func_74768_a("band2", this.b2.ordinal());
        NBT.func_74768_a("band3", this.b3.ordinal());
        NBT.func_74768_a("sel", this.selectedCurrent);
    }

    @Override
    public float getHeight() {
        return 0.75f;
    }

    @Override
    public float getWidth() {
        return 0.5f;
    }

    @Override
    public boolean canConnect() {
        return this.selectedCurrent > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void setColor(ColorBand band, int digit) {
        switch (digit) {
            case 1: {
                this.b1 = band;
                break;
            }
            case 2: {
                this.b2 = band;
                break;
            }
            case 3: {
                this.b3 = band;
            }
        }
    }

    public static enum ColorBand {
        BLACK(ReikaDyeHelper.BLACK),
        BROWN(ReikaDyeHelper.BROWN),
        RED(ReikaDyeHelper.RED),
        ORANGE(ReikaDyeHelper.ORANGE),
        YELLOW(ReikaDyeHelper.YELLOW),
        GREEN(ReikaDyeHelper.LIME),
        BLUE(ReikaDyeHelper.BLUE),
        PURPLE(ReikaDyeHelper.PURPLE),
        GRAY(ReikaDyeHelper.GRAY),
        WHITE(ReikaDyeHelper.WHITE);

        public final ReikaDyeHelper renderColor;
        public static final ColorBand[] bandList;

        private ColorBand(ReikaDyeHelper color) {
            this.renderColor = color;
        }

        public static ColorBand getBandFromColor(ReikaDyeHelper color) {
            for (int i = 0; i < bandList.length; ++i) {
                ColorBand b = bandList[i];
                if (b.renderColor != color) continue;
                return b;
            }
            return null;
        }

        static {
            bandList = ColorBand.values();
        }
    }
}

