/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireFuse;
import Reika.ElectriCraft.Base.TileEntityWireComponent;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityFuse
extends TileEntityWireComponent
implements WireFuse,
NBTMachine {
    private boolean overloaded;
    private int currentLimit;
    public static final int[] TIERS = new int[]{32, 128, 1024, 8192};

    public TileEntityFuse() {
    }

    public TileEntityFuse(int limit) {
        this.currentLimit = limit;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
    }

    @Override
    public int getResistance() {
        return !this.isOverloaded() ? 0 : Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCurrent() {
        return this.currentLimit;
    }

    @Override
    public ElectriTiles getMachine() {
        return ElectriTiles.FUSE;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean isOverloaded() {
        return this.overloaded;
    }

    @Override
    public float getHeight() {
        return 0.625f;
    }

    @Override
    public float getWidth() {
        return 0.75f;
    }

    @Override
    public boolean canConnect() {
        return !this.isOverloaded();
    }

    @Override
    public void overload(int current) {
        this.overloaded = true;
        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Block)Blocks.field_150359_w);
        ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.fizz", (float)2.0f, (float)1.0f);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.COLOREDPARTICLE.ordinal(), (TileEntity)this, (int)24, (int[])new int[]{1, 1, 1, 32, 0});
    }

    @Override
    public void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.overloaded = NBT.func_74767_n("overload");
        this.currentLimit = NBT.func_74762_e("limit");
    }

    @Override
    public void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("overload", this.overloaded);
        NBT.func_74768_a("limit", this.currentLimit);
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass <= 1;
    }

    public NBTTagCompound getTagsToWriteToStack() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("currentlim", this.currentLimit);
        return tag;
    }

    public void setDataFromItemStackTag(NBTTagCompound NBT) {
        if (NBT != null) {
            this.currentLimit = NBT.func_74762_e("currentlim");
        }
    }

    public ArrayList<NBTTagCompound> getCreativeModeVariants() {
        ArrayList<NBTTagCompound> li = new ArrayList<NBTTagCompound>();
        for (int i = 0; i < TIERS.length; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("currentlim", TIERS[i]);
            li.add(tag);
        }
        return li;
    }

    public ArrayList<String> getDisplayTags(NBTTagCompound NBT) {
        ArrayList<String> li = new ArrayList<String>();
        if (NBT != null) {
            li.add("Current Limit: " + NBT.func_74762_e("currentlim") + "A");
        }
        return li;
    }
}

