/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities.ModInterface;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.ModList;
import Reika.ElectriCraft.Base.ElectriCable;
import Reika.ElectriCraft.Registry.ElectriTiles;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"ic2.api.energy.tile.IEnergyConductor"})
public class TileEntityEUCable
extends ElectriCable
implements IEnergyConductor {
    public static final double CAPACITY = Double.MAX_VALUE;

    public void onFirstTick(World world, int x, int y, int z) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.addTileToNet();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.IC2)
    private void addTileToNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalidate) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.removeTileFromNet();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.IC2)
    private void removeTileFromNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }

    public boolean acceptsEnergyFrom(TileEntity te, ForgeDirection dir) {
        return te instanceof IEnergyTile;
    }

    public boolean emitsEnergyTo(TileEntity te, ForgeDirection dir) {
        return te instanceof IEnergyTile;
    }

    public double getConductionLoss() {
        return 1.0E-12;
    }

    public double getInsulationEnergyAbsorption() {
        return Double.POSITIVE_INFINITY;
    }

    public double getInsulationBreakdownEnergy() {
        return Double.MAX_VALUE;
    }

    public double getConductorBreakdownEnergy() {
        return Double.MAX_VALUE;
    }

    public void removeInsulation() {
    }

    public void removeConductor() {
        this.delete();
    }

    @Override
    public ElectriTiles getMachine() {
        return ElectriTiles.EUCABLE;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected boolean connectsToTile(TileEntity te, ForgeDirection dir) {
        if (te instanceof IEnergyEmitter && ((IEnergyEmitter)te).emitsEnergyTo((TileEntity)this, dir.getOpposite())) {
            return true;
        }
        if (te instanceof IEnergyAcceptor && ((IEnergyAcceptor)te).acceptsEnergyFrom((TileEntity)this, dir.getOpposite())) {
            return true;
        }
        return te instanceof WorldRift;
    }
}

