/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Registry;

import Reika.CondensedOres.API.CondensedOreAPI;
import Reika.DragonAPI.Interfaces.Registry.OreEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.ReikaTwilightHelper;
import Reika.DragonAPI.ModList;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.Registry.ElectriBlocks;
import Reika.ElectriCraft.Registry.ElectriItems;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.oredict.OreDictionary;

public enum ElectriOres implements OreEnum
{
    COPPER(32, 64, 6, 8, 0, 0.5f, 1, "ore.copper"),
    TIN(48, 72, 8, 8, 0, 0.2f, 1, "ore.tin"),
    SILVER(0, 32, 6, 4, 0, 0.8f, 2, "ore.silver"),
    NICKEL(16, 48, 8, 6, 0, 0.3f, 1, "ore.nickel"),
    ALUMINUM(60, 128, 8, 10, 0, 0.4f, 1, "ore.aluminum"),
    PLATINUM(0, 16, 4, 2, 0, 1.0f, 2, "ore.platinum");

    public final int minY;
    public final int maxY;
    public final int veinSize;
    public final int perChunk;
    public final int dimensionID;
    public final String oreName;
    public final int harvestLevel;
    public final float xpDropped;
    public static final ElectriOres[] oreList;
    private static final EnumMap<ElectriOres, Boolean> equivalents;

    private ElectriOres(int min, int max, int size, int count, int dim, float xp, int level, String name) {
        this.minY = min;
        this.maxY = max;
        this.veinSize = size;
        this.perChunk = count;
        this.dimensionID = dim;
        this.oreName = StatCollector.func_74838_a((String)name);
        this.harvestLevel = level;
        this.xpDropped = xp;
    }

    public String toString() {
        return this.name() + " " + this.perChunk + "x" + this.veinSize + " between " + this.minY + " and " + this.maxY;
    }

    public static ElectriOres getOre(IBlockAccess iba, int x, int y, int z) {
        Block id = iba.func_147439_a(x, y, z);
        int meta = iba.func_72805_g(x, y, z);
        if (id != ElectriBlocks.ORE.getBlockInstance()) {
            return null;
        }
        return oreList[meta];
    }

    public static ElectriOres getOre(Block id, int meta) {
        if (id != ElectriBlocks.ORE.getBlockInstance()) {
            return null;
        }
        return meta < oreList.length ? oreList[meta] : null;
    }

    public String getTextureName() {
        return "ElectriCraft:ore" + ReikaStringParser.capFirstChar((String)this.name());
    }

    public String getDictionaryName() {
        return "ore" + ReikaStringParser.capFirstChar((String)this.name());
    }

    public String getProductDictionaryName() {
        switch (this) {
            default: 
        }
        return "ingot" + ReikaStringParser.capFirstChar((String)this.name());
    }

    public Block getBlock() {
        return ElectriBlocks.ORE.getBlockInstance();
    }

    public int getBlockMetadata() {
        return this.ordinal();
    }

    public ItemStack getOreBlock() {
        return new ItemStack(this.getBlock(), 1, this.getBlockMetadata());
    }

    public ItemStack getProduct() {
        return ElectriItems.INGOTS.getStackOfMetadata(this.ordinal());
    }

    public List<ItemStack> getOreDrop(int meta) {
        return ReikaJavaLibrary.makeListFrom((Object)new ItemStack(ElectriBlocks.ORE.getBlockInstance(), 1, meta));
    }

    public String getProductName() {
        switch (this) {
            default: 
        }
        return StatCollector.func_74838_a((String)("Items." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public Block getReplaceableBlock() {
        switch (this.dimensionID) {
            case 0: {
                return Blocks.field_150348_b;
            }
            case 1: {
                return Blocks.field_150377_bs;
            }
            case -1: {
                return Blocks.field_150424_aL;
            }
            case 7: {
                return Blocks.field_150348_b;
            }
        }
        return Blocks.field_150348_b;
    }

    public boolean isValidDimension(int id) {
        if (id == this.dimensionID) {
            return true;
        }
        if (id == ReikaTwilightHelper.getDimensionID() && this.dimensionID == 0) {
            return true;
        }
        return this.dimensionID == 0 && id != -1 && id != 1;
    }

    public boolean isValidBiome(BiomeGenBase biome) {
        switch (this) {
            default: 
        }
        return true;
    }

    public boolean canGenerateInChunk(World world, int chunkX, int chunkZ) {
        int id = world.field_73011_w.field_76574_g;
        if (!this.shouldGen()) {
            return false;
        }
        if (!this.isValidDimension(id)) {
            return false;
        }
        return this.isValidBiome(world.func_72807_a(chunkX << 4, chunkZ << 4)) || id == ReikaTwilightHelper.getDimensionID();
    }

    private boolean shouldGen() {
        return true;
    }

    public boolean canGenAt(World world, int x, int y, int z) {
        return this.isOreEnabled();
    }

    public boolean isOreEnabled() {
        if (ElectriCraft.config.isOreGenEnabled(this)) {
            return true;
        }
        if (ModList.CONDENSEDORES.isLoaded() && CondensedOreAPI.instance.doesBlockGenerate(this.getBlock(), this.getBlockMetadata())) {
            return false;
        }
        return !this.hasEquivalents();
    }

    public boolean hasEquivalents() {
        Boolean b = equivalents.get((Object)this);
        if (b == null) {
            ArrayList li = OreDictionary.getOres((String)this.getDictionaryName());
            boolean flag = false;
            for (int i = 0; i < li.size() && !flag; ++i) {
                ItemStack is = (ItemStack)li.get(i);
                if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.getOreBlock())) continue;
                b = true;
                flag = true;
            }
            b = flag;
            equivalents.put(this, b);
        }
        return b;
    }

    public boolean dropsSelf(int meta) {
        List<ItemStack> li = this.getOreDrop(meta);
        return li.size() == 1 && ReikaItemHelper.matchStackWithBlock((ItemStack)li.get(0), (Block)ElectriBlocks.ORE.getBlockInstance()) && li.get(0).func_77960_j() == meta;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public float getXPDropped(World world, int x, int y, int z) {
        return this.xpDropped;
    }

    public boolean dropsSelf(World world, int x, int y, int z) {
        return this.dropsSelf(world.func_72805_g(x, y, z));
    }

    public String getHarvestTool() {
        return "pickaxe";
    }

    public boolean enforceHarvestLevel() {
        return false;
    }

    public TileEntity getTileEntity(World world, int x, int y, int z) {
        return null;
    }

    public int getRandomGeneratedYCoord(World world, int posX, int posZ, Random random) {
        return this.minY + random.nextInt(this.maxY - this.minY + 1);
    }

    static {
        oreList = ElectriOres.values();
        equivalents = new EnumMap(ElectriOres.class);
    }
}

