/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Registry;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Interfaces.Registry.ItemEnum;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.ElectriCraft.Base.ElectriItemBase;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.Items.ItemBatteryPlacer;
import Reika.ElectriCraft.Items.ItemEUBatteryPlacer;
import Reika.ElectriCraft.Items.ItemElectriBook;
import Reika.ElectriCraft.Items.ItemElectriPlacer;
import Reika.ElectriCraft.Items.ItemEnergyCrystal;
import Reika.ElectriCraft.Items.ItemRFBatteryPlacer;
import Reika.ElectriCraft.Items.ItemWirePlacer;
import Reika.ElectriCraft.Registry.BatteryType;
import Reika.ElectriCraft.Registry.ElectriCrafting;
import Reika.ElectriCraft.Registry.ElectriOres;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.ElectriCraft.Registry.WireType;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.ShapedOreRecipe;

public enum ElectriItems implements ItemEnum
{
    PLACER(0, false, "item.placer", ItemElectriPlacer.class),
    INGOTS(16, true, "item.Electriingots", ElectriItemBase.class),
    WIRE(1, true, "machine.wire", ItemWirePlacer.class),
    BATTERY(2, true, "machine.battery", ItemBatteryPlacer.class),
    CRAFTING(32, true, "item.crafting", ElectriItemBase.class),
    CRYSTAL(48, true, "item.electricrystal", ItemEnergyCrystal.class),
    RFBATTERY(3, false, "machine.rfbattery", ItemRFBatteryPlacer.class),
    BOOK(4, false, "item.electribook", ItemElectriBook.class),
    EUBATTERY(5, false, "machine.eubattery", ItemEUBatteryPlacer.class);

    private int index;
    private boolean hasSubtypes;
    private String name;
    private Class itemClass;
    private int maxindex;
    public static final ElectriItems[] itemList;

    private ElectriItems(int tex, boolean sub, String n2, Class<? extends Item> iCl) {
        this.index = tex;
        this.hasSubtypes = sub;
        this.name = n2;
        this.itemClass = iCl;
    }

    public Class[] getConstructorParamTypes() {
        return new Class[]{Integer.TYPE};
    }

    public Object[] getConstructorParams() {
        return new Object[]{this.getTextureIndex()};
    }

    public int getTextureIndex() {
        return this.index;
    }

    public static boolean isRegistered(ItemStack is) {
        return ElectriItems.isRegistered(is.func_77973_b());
    }

    public static boolean isRegistered(Item id) {
        for (int i = 0; i < itemList.length; ++i) {
            if (itemList[i].getItemInstance() != id) continue;
            return true;
        }
        return false;
    }

    public static ElectriItems getEntryByID(Item id) {
        for (int i = 0; i < itemList.length; ++i) {
            if (itemList[i].getItemInstance() != id) continue;
            return itemList[i];
        }
        return null;
    }

    public static ElectriItems getEntry(ItemStack is) {
        if (is == null) {
            return null;
        }
        return ElectriItems.getEntryByID(is.func_77973_b());
    }

    public String getName(int dmg) {
        if (this.hasMultiValuedName()) {
            return this.getMultiValuedName(dmg);
        }
        return this.name;
    }

    public String getBasicName() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public String getMultiValuedName(int dmg) {
        if (!this.hasMultiValuedName()) {
            throw new RuntimeException("Item " + this.name + " was called for a multi-name, yet does not have one!");
        }
        switch (this) {
            case INGOTS: {
                return StatCollector.func_74838_a((String)("ingot." + ElectriOres.oreList[dmg].name().toLowerCase(Locale.ENGLISH)));
            }
            case CRAFTING: {
                return ElectriCrafting.craftingList[dmg].getName();
            }
            case CRYSTAL: {
                if (dmg == BatteryType.batteryList.length + 1) {
                    return StatCollector.func_74838_a((String)"energycrystal.eu");
                }
                if (dmg == BatteryType.batteryList.length) {
                    return StatCollector.func_74838_a((String)"energycrystal.rf");
                }
                return StatCollector.func_74838_a((String)("energycrystal." + BatteryType.batteryList[dmg].name().toLowerCase(Locale.ENGLISH)));
            }
            case BATTERY: {
                return BatteryType.batteryList[dmg].getName();
            }
            case PLACER: {
                return ElectriTiles.TEList[dmg].getName();
            }
            case WIRE: {
                int d = dmg % 16;
                String s = dmg >= 16 ? "wire.insulated." : "wire.";
                return d < WireType.wireList.length ? StatCollector.func_74838_a((String)(s + WireType.wireList[d].name().toLowerCase(Locale.ENGLISH))) : "";
            }
        }
        throw new RuntimeException("Item " + this.name + " was called for a multi-name, but it was not registered!");
    }

    public String getUnlocalizedName() {
        return ReikaStringParser.stripSpaces((String)this.name).toLowerCase(Locale.ENGLISH);
    }

    public Item getItemInstance() {
        return ElectriCraft.items[this.ordinal()];
    }

    public boolean hasMultiValuedName() {
        return this.hasSubtypes || this == PLACER;
    }

    public boolean isCreativeOnly() {
        return false;
    }

    public int getNumberMetadatas() {
        if (!this.hasSubtypes) {
            return 1;
        }
        switch (this) {
            case INGOTS: {
                return ElectriOres.oreList.length;
            }
            case WIRE: {
                return 32;
            }
            case CRAFTING: {
                return ElectriCrafting.craftingList.length;
            }
            case CRYSTAL: {
                return BatteryType.batteryList.length + 2;
            }
            case BATTERY: {
                return BatteryType.batteryList.length;
            }
        }
        throw new RegistrationException((DragonAPIMod)ElectriCraft.instance, "Item " + this.name + " has subtypes but the number was not specified!");
    }

    public ItemStack getCraftedProduct(int amt) {
        return new ItemStack(this.getItemInstance(), amt, 0);
    }

    public ItemStack getCraftedMetadataProduct(int amt, int meta) {
        return new ItemStack(this.getItemInstance(), amt, meta);
    }

    public ItemStack getStackOf() {
        return this.getCraftedProduct(1);
    }

    public ItemStack getStackOfMetadata(int meta) {
        return this.getCraftedMetadataProduct(1, meta);
    }

    public boolean overridesRightClick(ItemStack is) {
        switch (this) {
            default: 
        }
        return false;
    }

    public Class getObjectClass() {
        return this.itemClass;
    }

    public boolean isDummiedOut() {
        return this.itemClass == null;
    }

    public void addRecipe(Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getStackOf(), (Object[])params);
            WorktableRecipes.getInstance().addRecipe(this.getStackOf(), RecipeHandler.RecipeLevel.CORE, params);
        }
    }

    public void addSizedRecipe(int num, Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getCraftedProduct(num), (Object[])params);
            WorktableRecipes.getInstance().addRecipe(this.getCraftedProduct(num), RecipeHandler.RecipeLevel.CORE, params);
        }
    }

    public void addMetaRecipe(int meta, Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getStackOfMetadata(meta), (Object[])params);
            WorktableRecipes.getInstance().addRecipe(this.getStackOfMetadata(meta), RecipeHandler.RecipeLevel.CORE, params);
        }
    }

    public void addSizedMetaRecipe(int meta, int num, Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getCraftedMetadataProduct(num, meta), (Object[])params);
            WorktableRecipes.getInstance().addRecipe(this.getCraftedMetadataProduct(num, meta), RecipeHandler.RecipeLevel.CORE, params);
        }
    }

    public void addShapelessRecipe(Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addShapelessRecipe((ItemStack)this.getStackOf(), (Object[])params);
            WorktableRecipes.getInstance().addShapelessRecipe(this.getStackOf(), RecipeHandler.RecipeLevel.CORE, params);
        }
    }

    public void addRecipe(IRecipe ir) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((IRecipe)ir);
            WorktableRecipes.getInstance().addRecipe(ir, RecipeHandler.RecipeLevel.CORE);
        }
    }

    public void addOreRecipe(Object ... in) {
        ItemStack out;
        boolean added;
        if (!this.isDummiedOut() && (added = ReikaRecipeHelper.addOreRecipe((ItemStack)(out = this.getStackOf()), (Object[])in))) {
            WorktableRecipes.getInstance().addRecipe((IRecipe)new ShapedOreRecipe(out, in), RecipeHandler.RecipeLevel.CORE);
        }
    }

    public boolean isAvailableInCreativeInventory() {
        return !this.isDummiedOut();
    }

    public boolean isAvailableInCreative(ItemStack item) {
        switch (this) {
            case WIRE: {
                if (item.func_77960_j() < WireType.wireList.length) {
                    return true;
                }
                return ReikaMathLibrary.isValueInsideBoundsIncl((int)16, (int)(16 + WireType.wireList.length - 1), (int)item.func_77960_j());
            }
        }
        return true;
    }

    public boolean overwritingItem() {
        return false;
    }

    public boolean isPlacerItem() {
        switch (this) {
            case BATTERY: 
            case PLACER: 
            case WIRE: 
            case RFBATTERY: 
            case EUBATTERY: {
                return true;
            }
        }
        return false;
    }

    static {
        itemList = ElectriItems.values();
    }
}

