/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Network;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.ElectriCraft.Auxiliary.ElectriNetworkEvent;
import Reika.ElectriCraft.Auxiliary.Interfaces.NetworkTile;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireEmitter;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireReceiver;
import Reika.ElectriCraft.Auxiliary.WrappedSource;
import Reika.ElectriCraft.Base.NetworkTileEntity;
import Reika.ElectriCraft.Base.WiringTile;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.ElectriNetworkManager;
import Reika.ElectriCraft.Network.NetworkNode;
import Reika.ElectriCraft.Network.PathCalculator;
import Reika.ElectriCraft.Network.WirePath;
import Reika.ElectriCraft.NetworkObject;
import Reika.ElectriCraft.TileEntities.TileEntityWire;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;

public final class WireNetwork
implements NetworkObject {
    private final HashMap<WorldLocation, WiringTile> wires = new HashMap();
    private final HashMap<WorldLocation, WireReceiver> sinks = new HashMap();
    private final HashMap<WorldLocation, WireEmitter> sources = new HashMap();
    private final HashMap<WorldLocation, WrappedSource> wrappers = new HashMap();
    private final HashMap<Coordinate, NetworkNode> nodes = new HashMap();
    private final Collection<WirePath> paths = new ArrayList<WirePath>();
    private final HashSet<WorldLocation> rifts = new HashSet();
    private final HashMap<WiringTile, Integer> pointVoltages = new HashMap();
    private final HashMap<WiringTile, Integer> pointCurrents = new HashMap();
    private final HashMap<WireReceiver, Integer> terminalVoltages = new HashMap();
    private final HashMap<WireReceiver, Integer> terminalCurrents = new HashMap();
    private final HashMap<WireReceiver, Integer> avgCurrents = new HashMap();
    private final HashMap<WireReceiver, Float> numSources = new HashMap();
    private final HashSet<Integer> dimIDs = new HashSet();
    private final HashSet<Integer> loadedDimIDs = new HashSet();
    private int interWireConnections;
    private boolean shorted = false;
    private boolean reUpdateThisTick;
    static final ForgeDirection[] dirs = ForgeDirection.values();
    public static final int TORQUE_PER_AMP = 8;
    private static final int MAX_PATHS = 500;
    private static final int MAX_INTERWIRE = 500;

    public WireNetwork() {
        ElectriNetworkManager.instance.addNetwork(this);
    }

    public void clearCache() {
        this.terminalCurrents.clear();
        this.terminalVoltages.clear();
        this.pointCurrents.clear();
        this.pointVoltages.clear();
        this.avgCurrents.clear();
        this.numSources.clear();
    }

    public boolean isMultiWorld() {
        return this.dimIDs.size() > 1;
    }

    private int getMaxInputVoltage() {
        int max = 0;
        for (WireEmitter e : this.sources.values()) {
            max = Math.max(max, e.getGenVoltage());
        }
        return max;
    }

    public boolean isLive() {
        return this.getMaxInputVoltage() > 0;
    }

    public int getNumberSources() {
        return this.sources.size();
    }

    public int getNumberSinks() {
        return this.sinks.size();
    }

    @Override
    public void tick(ElectriNetworkEvent.ElectriNetworkTickEvent evt) {
        boolean flag = false;
        for (WirePath path : this.paths) {
            if (!path.tick(evt)) continue;
            this.updateWires(false);
            flag = true;
        }
        for (WrappedSource src : this.wrappers.values()) {
            if (!src.needsUpdate()) continue;
            this.updateWires(false);
            flag = true;
        }
        if (flag) {
            return;
        }
        for (WiringTile w : this.wires.values()) {
            if (!(w instanceof TileEntityWire)) continue;
            TileEntityWire te = (TileEntityWire)w;
            int current = this.getPointCurrent(w);
            if (current <= te.getMaxCurrent()) continue;
            te.overload(current);
        }
        if (this.isEmpty()) {
            this.clear(true);
            ElectriNetworkManager.instance.scheduleNetworkDiscard(this);
        }
        if (this.shorted) {
            this.shorted = false;
            this.updateWires(false);
        }
    }

    @Override
    public void repath(ElectriNetworkEvent.ElectriNetworkRepathEvent evt) {
        if (this.reUpdateThisTick) {
            this.doRepath();
            this.reUpdateThisTick = false;
        }
    }

    private void doRepath() {
        this.recalculatePaths();
        for (WiringTile wiringTile : this.wires.values()) {
            wiringTile.onNetworkChanged();
        }
        for (WireEmitter wireEmitter : this.sources.values()) {
            wireEmitter.onNetworkChanged();
        }
        for (WireReceiver wireReceiver : this.sinks.values()) {
            wireReceiver.onNetworkChanged();
        }
    }

    public int getPointVoltage(WiringTile te) {
        if (this.shorted) {
            return 0;
        }
        Integer val = this.pointVoltages.get(te);
        if (val == null) {
            val = this.calcPointVoltage(te);
            this.pointVoltages.put(te, val);
        }
        return val;
    }

    public int getPointCurrent(WiringTile te) {
        if (this.shorted) {
            return 0;
        }
        Integer val = this.pointCurrents.get(te);
        if (val == null) {
            val = this.calcPointCurrent(te);
            this.pointCurrents.put(te, val);
        }
        return val;
    }

    private int calcPointVoltage(WiringTile te) {
        if (this.paths.isEmpty()) {
            return 0;
        }
        int sv = Integer.MAX_VALUE;
        for (WirePath path : this.paths) {
            int v;
            if (!path.containsBlock(te) || path.start.getGenVoltage() <= 0 || (v = path.getVoltageAt(te)) >= sv) continue;
            sv = v;
        }
        return sv == Integer.MAX_VALUE ? 0 : sv;
    }

    private int calcPointCurrent(WiringTile te) {
        if (this.paths.isEmpty()) {
            return 0;
        }
        int sa = 0;
        for (WirePath path : this.paths) {
            if (!path.containsBlock(te)) continue;
            int a = path.getPathCurrent();
            sa += a;
        }
        return sa;
    }

    @SubscribeEvent
    public void onAddWorld(WorldEvent.Load evt) {
        if (this.dimIDs.contains(evt.world.field_73011_w.field_76574_g)) {
            this.loadedDimIDs.add(evt.world.field_73011_w.field_76574_g);
        }
    }

    @SubscribeEvent
    public void onRemoveWorld(WorldEvent.Unload evt) {
        this.loadedDimIDs.remove(evt.world.field_73011_w.field_76574_g);
        if (this.loadedDimIDs.isEmpty()) {
            this.clear(true);
        }
    }

    public boolean isEmpty() {
        return this.wires.isEmpty() && this.sinks.isEmpty() && this.sources.isEmpty();
    }

    public int tickRate() {
        return 1;
    }

    public void merge(WireNetwork n) {
        if (n != this) {
            ArrayList<NetworkTile> li = new ArrayList<NetworkTile>();
            for (WiringTile wire : n.wires.values()) {
                wire.setNetwork(this);
                li.add(wire);
            }
            for (WireReceiver emitter : n.sinks.values()) {
                if (li.contains(emitter)) continue;
                emitter.setNetwork(this);
                li.add(emitter);
            }
            for (WireEmitter source : n.sources.values()) {
                if (li.contains(source)) continue;
                source.setNetwork(this);
                li.add(source);
            }
            for (Coordinate key : n.nodes.keySet()) {
                NetworkNode node = n.nodes.get(key);
                this.nodes.put(key, node);
            }
            this.interWireConnections += n.interWireConnections;
            n.clear(false);
        }
        this.updateWires(true);
    }

    private void clear(boolean clearTiles) {
        if (clearTiles) {
            for (WiringTile wiringTile : this.wires.values()) {
                wiringTile.resetNetwork();
            }
            for (WireReceiver wireReceiver : this.sinks.values()) {
                wireReceiver.resetNetwork();
            }
            for (WireEmitter wireEmitter : this.sources.values()) {
                wireEmitter.resetNetwork();
            }
        }
        this.wires.clear();
        this.sinks.clear();
        this.sources.clear();
        this.wrappers.clear();
        this.nodes.clear();
        this.paths.clear();
        this.rifts.clear();
        this.dimIDs.clear();
        this.loadedDimIDs.clear();
        this.clearCache();
    }

    public void addElement(NetworkTile te) {
        boolean changed = false;
        if (!te.isConnectable()) {
            return;
        }
        if (te instanceof WireEmitter) {
            changed |= this.addSource((WireEmitter)te);
        }
        if (te instanceof WireReceiver) {
            changed |= !te.equals(this.sinks.put(this.getLocation(te), (WireReceiver)te));
        }
        if (te instanceof WiringTile) {
            WiringTile wire = (WiringTile)te;
            changed |= !te.equals(this.wires.put(this.getLocation(te), wire));
            for (int k = 0; k < 6; ++k) {
                ForgeDirection side = dirs[k];
                TileEntity adj2 = wire.getAdjacentTileEntity(side);
                if (!(adj2 instanceof WiringTile)) continue;
                WiringTile wire2 = (WiringTile)adj2;
                ArrayList<ForgeDirection> sides = new ArrayList<ForgeDirection>();
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection dir = dirs[i];
                    TileEntity adj = wire2.getAdjacentTileEntity(dir);
                    if (!(adj instanceof NetworkTile)) continue;
                    NetworkTile nw = (NetworkTile)adj;
                    if (!((NetworkTile)adj).canNetworkOnSide(dir.getOpposite())) continue;
                    sides.add(dir);
                }
                if (sides.size() <= 2 || this.hasNode(wire2.field_145851_c, wire2.field_145848_d, wire2.field_145849_e)) continue;
                this.nodes.put(new Coordinate(wire2.field_145851_c, wire2.field_145848_d, wire2.field_145849_e), new NetworkNode(this, wire2, sides));
                this.interWireConnections += sides.size() - 2;
            }
        }
        if (changed) {
            this.dimIDs.add(te.getWorld().field_73011_w.field_76574_g);
            this.updateWires(true);
        }
    }

    private boolean addSource(WireEmitter te) {
        boolean flag;
        boolean bl = flag = !te.equals(this.sources.put(this.getLocation(te), te));
        if (te instanceof WrappedSource) {
            flag |= !te.equals(this.wrappers.put(this.getLocation(te), (WrappedSource)te));
        }
        return flag;
    }

    private WorldLocation getLocation(NetworkTile te) {
        return new WorldLocation(te.getWorld(), te.getX(), te.getY(), te.getZ());
    }

    private void removeSource(WireEmitter te) {
        this.sources.remove(te);
        if (te instanceof WrappedSource) {
            this.wrappers.remove(te);
        }
    }

    public void checkRiftConnections() {
        boolean flag = false;
        for (WorldLocation loc : this.rifts) {
            if (loc.getTileEntity() instanceof WorldRift) continue;
            flag = true;
            break;
        }
        if (flag) {
            this.clear(true);
        }
    }

    public void updateWires() {
        this.updateWires(false);
    }

    void updateWires(boolean force) {
        if (force) {
            this.doRepath();
        } else {
            this.reUpdateThisTick = true;
        }
    }

    private void recalculatePaths() {
        this.paths.clear();
        this.rifts.clear();
        this.dimIDs.clear();
        this.loadedDimIDs.clear();
        this.interWireConnections = 0;
        this.clearCache();
        for (WireEmitter src : this.sources.values()) {
            for (WireReceiver sink : this.sinks.values()) {
                if (src == sink) continue;
                PathCalculator pc = new PathCalculator(src, sink, this);
                pc.calculatePaths();
                WirePath path = pc.getShortestPath();
                if (path == null) continue;
                this.paths.add(path);
                this.dimIDs.addAll(path.getDimensions());
                this.loadedDimIDs.addAll(this.dimIDs);
                this.validatePathLimit();
                this.rifts.addAll(pc.getRifts());
            }
        }
        ElectriCraft.logger.debug((Object)("Remapped network " + this));
    }

    private void validatePathLimit() {
        if (this.paths.size() >= 500 || this.interWireConnections > 500) {
            for (WiringTile w : this.wires.values()) {
                if (!(w instanceof TileEntityWire)) continue;
                ((TileEntityWire)w).overload(Integer.MAX_VALUE);
            }
        }
    }

    public float getNumberSourcesPer(WireReceiver te) {
        if (this.shorted) {
            return 0.0f;
        }
        Float val = this.numSources.get(te);
        if (val == null) {
            val = Float.valueOf(this.calcNumberSourcesPer(te));
            this.numSources.put(te, val);
        }
        return val.floatValue();
    }

    public int getAverageCurrent(WireReceiver te) {
        if (this.shorted) {
            return 0;
        }
        Integer val = this.avgCurrents.get(te);
        if (val == null) {
            val = this.calcAvgCurrent(te);
            this.avgCurrents.put(te, val);
        }
        return val;
    }

    public int getTerminalCurrent(WireReceiver te) {
        if (this.shorted) {
            return 0;
        }
        Integer val = this.terminalCurrents.get(te);
        if (val == null) {
            val = this.calcTerminalCurrent(te);
            this.terminalCurrents.put(te, val);
        }
        return val;
    }

    public int getTerminalVoltage(WireReceiver te) {
        if (this.shorted) {
            return 0;
        }
        Integer val = this.terminalVoltages.get(te);
        if (val == null) {
            val = this.calcTerminalVoltage(te);
            this.terminalVoltages.put(te, val);
        }
        return val;
    }

    private int calcTerminalCurrent(WireReceiver te) {
        int a = 0;
        for (WirePath path : this.paths) {
            if (!path.endsAt(te.getX(), te.getY(), te.getZ())) continue;
            int pa = path.getPathCurrent();
            a += pa;
        }
        return a;
    }

    private int calcAvgCurrent(WireReceiver te) {
        int a = 0;
        int c = 0;
        for (WirePath path : this.paths) {
            if (!path.endsAt(te.getX(), te.getY(), te.getZ())) continue;
            int pa = path.getPathCurrent();
            a += pa;
            ++c;
        }
        return c > 0 ? a / c : 0;
    }

    private float calcNumberSourcesPer(WireReceiver te) {
        float f = 0.0f;
        for (WirePath path : this.paths) {
            if (!path.canConduct() || !path.endsAt(te.getX(), te.getY(), te.getZ())) continue;
            f += 1.0f / (float)this.getNumberPathsStartingAt(path.start);
        }
        return f;
    }

    private int calcTerminalVoltage(WireReceiver te) {
        return this.getLowestVoltageOfPaths(te);
    }

    public int getNumberPaths() {
        return this.paths.size();
    }

    private int getLowestVoltageOfPaths(WireReceiver te) {
        int v = Integer.MAX_VALUE;
        if (this.paths.isEmpty()) {
            return 0;
        }
        boolean someV = false;
        for (WirePath path : this.paths) {
            int pv;
            if (!path.endsAt(te.getX(), te.getY(), te.getZ()) || (pv = path.getTerminalVoltage()) == 0) continue;
            someV = true;
            if (pv >= v) continue;
            v = pv;
        }
        return someV ? v : 0;
    }

    private int getAverageVoltageOfPaths(WireReceiver te) {
        int v = 0;
        int c = 0;
        if (this.paths.isEmpty()) {
            return 0;
        }
        for (WirePath path : this.paths) {
            if (!path.endsAt(te.getX(), te.getY(), te.getZ())) continue;
            int pv = path.getTerminalVoltage();
            v += pv;
            ++c;
        }
        return c > 0 ? v / c : 0;
    }

    public boolean hasNode(int x, int y, int z) {
        return this.nodes.containsKey(new Coordinate(x, y, z));
    }

    NetworkNode getNodeAt(int x, int y, int z) {
        return this.nodes.get(new Coordinate(x, y, z));
    }

    NetworkNode getNodeAt(WiringTile w) {
        return this.getNodeAt(w.field_145851_c, w.field_145848_d, w.field_145849_e);
    }

    public void shortNetwork() {
        this.shorted = true;
        this.updateWires(false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sources.size() + "SR/" + this.wires.size() + "W/" + this.sinks.size() + "SN-#");
        sb.append(this.paths);
        sb.append(";{" + this.hashCode() + "}");
        sb.append("$[" + this.dimIDs + "]");
        return sb.toString();
    }

    public void removeElement(NetworkTileEntity te) {
        if (te instanceof WireEmitter) {
            this.removeSource((WireEmitter)((Object)te));
        }
        if (te instanceof WireReceiver) {
            this.sinks.remove(te);
        }
        if (te instanceof WiringTile) {
            this.wires.remove(te);
        }
        this.rebuild();
    }

    private void rebuild() {
        ArrayList<NetworkTile> li = new ArrayList<NetworkTile>();
        for (NetworkTile networkTile : this.wires.values()) {
            li.add(networkTile);
        }
        for (NetworkTile networkTile : this.sinks.values()) {
            if (li.contains(networkTile)) continue;
            li.add(networkTile);
        }
        for (NetworkTile networkTile : this.sources.values()) {
            if (li.contains(networkTile)) continue;
            li.add(networkTile);
        }
        this.clear(true);
        for (NetworkTile networkTile : li) {
            networkTile.findAndJoinNetwork(networkTile.getWorld(), networkTile.getX(), networkTile.getY(), networkTile.getZ());
        }
    }

    ArrayList<WirePath> getPathsStartingAt(WireEmitter start) {
        ArrayList<WirePath> li = new ArrayList<WirePath>();
        for (WirePath path : this.paths) {
            if (!path.startsAt(start.getX(), start.getY(), start.getZ())) continue;
            li.add(path);
        }
        return li;
    }

    ArrayList<WirePath> getPathsEndingAt(WireReceiver end) {
        ArrayList<WirePath> li = new ArrayList<WirePath>();
        for (WirePath path : this.paths) {
            if (!path.endsAt(end.getX(), end.getY(), end.getZ())) continue;
            li.add(path);
        }
        return li;
    }

    public int getNumberPathsStartingAt(WireEmitter start) {
        return this.getPathsStartingAt(start).size();
    }

    public PowerSourceList getInputSources(PowerSourceTracker io, ShaftMerger caller) {
        return this.getInputSources(io, caller, null);
    }

    public PowerSourceList getInputSources(PowerSourceTracker io, ShaftMerger caller, WireReceiver terminus) {
        PowerSourceList p = new PowerSourceList();
        if (terminus != null) {
            for (WirePath path : this.getPathsEndingAt(terminus)) {
                if (!path.canConduct() || !(path.start instanceof PowerSourceTracker)) continue;
                p.addAll(((PowerSourceTracker)path.start).getPowerSources(io, caller));
            }
        } else {
            for (WireEmitter w : this.sources.values()) {
                if (!(w instanceof PowerSourceTracker)) continue;
                p.addAll(((PowerSourceTracker)w).getPowerSources(io, caller));
            }
        }
        return p;
    }

    public int getTotalCurrent() {
        int val = 0;
        for (WirePath p : this.paths) {
            val += p.getPathCurrent();
        }
        return val;
    }
}

