/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft;

import Reika.DragonAPI.Auxiliary.PacketTypes;
import Reika.DragonAPI.Interfaces.PacketHandler;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.Registry.ElectriPackets;
import Reika.ElectriCraft.TileEntities.ModInterface.TileEntityRFCable;
import Reika.ElectriCraft.TileEntities.TileEntityTransformer;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ElectriPacketCore
implements PacketHandler {
    public void handleData(ReikaPacketHelper.PacketObj packet, World world, EntityPlayer ep) {
        DataInputStream inputStream = packet.getDataIn();
        int control = Integer.MIN_VALUE;
        ElectriPackets pack = null;
        int[] data = new int[]{};
        long longdata = 0L;
        float floatdata = 0.0f;
        int x = 0;
        int y = 0;
        int z = 0;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        boolean readinglong = false;
        String stringdata = null;
        UUID id = null;
        try {
            PacketTypes packetType = packet.getType();
            switch (packetType) {
                case FULLSOUND: {
                    break;
                }
                case SOUND: {
                    return;
                }
                case STRING: {
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    break;
                }
                case DATA: {
                    int i;
                    control = inputStream.readInt();
                    pack = ElectriPackets.getEnum(control);
                    int len = pack.numInts;
                    data = new int[len];
                    readinglong = false;
                    for (i = 0; i < len; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case POS: {
                    int i;
                    control = inputStream.readInt();
                    pack = ElectriPackets.getEnum(control);
                    dx = inputStream.readDouble();
                    dy = inputStream.readDouble();
                    dz = inputStream.readDouble();
                    int len = pack.numInts;
                    if (!pack.hasData()) break;
                    data = new int[len];
                    for (i = 0; i < len; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case UPDATE: {
                    control = inputStream.readInt();
                    break;
                }
                case FLOAT: {
                    control = inputStream.readInt();
                    floatdata = inputStream.readFloat();
                    break;
                }
                case SYNC: {
                    String name = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityData((World)world, (int)x, (int)y, (int)z, (String)name, (DataInputStream)inputStream);
                    return;
                }
                case TANK: {
                    String tank = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    int level = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityTankData((World)world, (int)x, (int)y, (int)z, (String)tank, (int)level);
                    return;
                }
                case RAW: {
                    control = inputStream.readInt();
                    int len = 1;
                    data = new int[len];
                    for (int i = 0; i < len; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case PREFIXED: {
                    control = inputStream.readInt();
                    int len = inputStream.readInt();
                    data = new int[len];
                    for (int i = 0; i < len; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case NBT: {
                    break;
                }
                case STRINGINT: 
                case STRINGINTLOC: {
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    data = new int[1];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case UUID: {
                    control = inputStream.readInt();
                    pack = ElectriPackets.getEnum(control);
                    long l1 = inputStream.readLong();
                    long l2 = inputStream.readLong();
                    id = new UUID(l1, l2);
                }
            }
            if (packetType.hasCoordinates()) {
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        try {
            switch (pack) {
                case RFCABLE: {
                    ((TileEntityRFCable)te).setRFLimit(data[0]);
                    break;
                }
                case TRANSFORMER: {
                    TileEntityTransformer tf = (TileEntityTransformer)te;
                    tf.setRatio(data[0], data[1]);
                }
            }
        }
        catch (Exception e) {
            ElectriCraft.logger.logError((Object)"Machine/item was deleted before its packet could be received!");
            ReikaChatHelper.writeString((String)"Machine/item was deleted before its packet could be received!");
            e.printStackTrace();
        }
    }
}

