/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Auxiliary;

import Reika.ElectriCraft.API.WrappableWireSource;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireEmitter;
import Reika.ElectriCraft.Network.WireNetwork;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import java.util.Collection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class WrappedSource
implements WireEmitter,
PowerSourceTracker {
    private final WrappableWireSource source;

    public WrappedSource(WrappableWireSource src) {
        this.source = src;
        if (!(src instanceof TileEntity)) {
            throw new IllegalArgumentException("You cannot wrap non-tile sources!");
        }
        if (!src.getClass().getName().startsWith("Reika")) {
            throw new IllegalArgumentException("This class is for internal use only!");
        }
    }

    @Override
    public void findAndJoinNetwork(World world, int x, int y, int z) {
    }

    @Override
    public WireNetwork getNetwork() {
        return null;
    }

    @Override
    public void setNetwork(WireNetwork n) {
    }

    @Override
    public void removeFromNetwork() {
    }

    @Override
    public void resetNetwork() {
    }

    @Override
    public void onNetworkChanged() {
    }

    @Override
    public boolean isConnectable() {
        return this.canEmitPower();
    }

    @Override
    public boolean canNetworkOnSide(ForgeDirection dir) {
        return this.canEmitPowerToSide(dir);
    }

    @Override
    public World getWorld() {
        return ((TileEntity)this.source).field_145850_b;
    }

    @Override
    public int getX() {
        return ((TileEntity)this.source).field_145851_c;
    }

    @Override
    public int getY() {
        return ((TileEntity)this.source).field_145848_d;
    }

    @Override
    public int getZ() {
        return ((TileEntity)this.source).field_145849_e;
    }

    @Override
    public int getGenVoltage() {
        return this.source.getOmega() * 8;
    }

    @Override
    public int getGenCurrent() {
        return this.source.getTorque() / 8;
    }

    @Override
    public boolean canEmitPowerToSide(ForgeDirection dir) {
        return this.source.canConnectToSide(dir);
    }

    @Override
    public boolean canEmitPower() {
        return this.source.isFunctional();
    }

    public boolean needsUpdate() {
        return this.source.hasPowerStatusChangedSinceLastTick();
    }

    public boolean equals(Object o) {
        return o instanceof WrappedSource && ((WrappedSource)o).source.equals(this.source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        return this.source.getPowerSources(io, caller);
    }

    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        this.source.getAllOutputs(c, dir);
    }

    public int getIoOffsetX() {
        return this.source.getIoOffsetX();
    }

    public int getIoOffsetY() {
        return this.source.getIoOffsetY();
    }

    public int getIoOffsetZ() {
        return this.source.getIoOffsetZ();
    }
}

