/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Math.MovingAverage;
import Reika.DragonAPI.Libraries.IO.ReikaFormatHelper;
import Reika.ElectriCraft.Auxiliary.Interfaces.BatteryTile;
import net.minecraft.util.EnumChatFormatting;

public class BatteryTracker {
    private final MovingAverage energyStored = new MovingAverage(10);
    private final MovingAverage energyFlow = new MovingAverage(10);
    private double lastEnergy = Double.NaN;

    public void update(BatteryTile t) {
        long energy = t.getStoredEnergy();
        this.energyStored.addValue((double)energy);
        if (this.lastEnergy != Double.NaN) {
            this.energyFlow.addValue((double)energy - this.lastEnergy);
        }
        this.lastEnergy = energy;
    }

    public String getAverageStorage(int decimals) {
        String format = "%." + decimals + "f";
        return String.format(format, this.energyStored.getAverage());
    }

    public String getAverageFlow(int decimals) {
        String format = "%s%." + decimals + "f";
        double avg = this.energyFlow.getAverage();
        return String.format(format, avg > 0.0 ? EnumChatFormatting.GREEN + "+" : (avg < 0.0 ? EnumChatFormatting.RED.toString() : ""), avg);
    }

    public String getTimeUntilFullOrEmpty(BatteryTile t) {
        double avg = this.energyFlow.getAverage();
        if (avg < 0.0) {
            double ticks = (double)t.getStoredEnergy() / -avg;
            return ReikaFormatHelper.getTickAsHMS((long)Math.round(ticks)) + " until empty";
        }
        if (avg > 0.0) {
            double limit = t.getMaxEnergy();
            double space = limit - (double)t.getStoredEnergy();
            double ticks = space / avg;
            return ReikaFormatHelper.getTickAsHMS((long)Math.round(ticks)) + " until full";
        }
        return "No net flow";
    }
}

