/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.waila;

import java.util.List;
import li.cil.oc.Localization$;
import li.cil.oc.Localization$Analyzer$;
import li.cil.oc.Localization$Assembler$;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.common.block.SimpleBlock;
import li.cil.oc.common.tileentity.AccessPoint;
import li.cil.oc.common.tileentity.Assembler;
import li.cil.oc.common.tileentity.Charger;
import li.cil.oc.common.tileentity.DiskDrive;
import li.cil.oc.common.tileentity.Hologram;
import li.cil.oc.common.tileentity.Keyboard;
import li.cil.oc.common.tileentity.Rack;
import li.cil.oc.common.tileentity.Screen;
import li.cil.oc.common.tileentity.traits.NotAnalyzable;
import li.cil.oc.util.ExtendedNBT$;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BlockDataProvider$
implements IWailaDataProvider {
    public static final BlockDataProvider$ MODULE$;
    private final String ConfigAddress;
    private final String ConfigEnergy;
    private final String ConfigComponentName;

    static {
        new BlockDataProvider$();
    }

    public String ConfigAddress() {
        return this.ConfigAddress;
    }

    public String ConfigEnergy() {
        return this.ConfigEnergy;
    }

    public String ConfigComponentName() {
        return this.ConfigComponentName;
    }

    public void init(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, SimpleBlock.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, Environment.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, SidedEnvironment.class);
        registrar.addConfig("OpenComputers", this.ConfigAddress());
        registrar.addConfig("OpenComputers", this.ConfigEnergy());
        registrar.addConfig("OpenComputers", this.ConfigComponentName());
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player2, TileEntity tileEntity, NBTTagCompound tag, World world, int x, int y, int z) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        TileEntity tileEntity2 = tileEntity;
        if (tileEntity2 instanceof SidedEnvironment) {
            TileEntity tileEntity3 = tileEntity2;
            boxedUnit2 = ExtendedNBT$.MODULE$.extendNBTTagCompound(tag).setNewTagList("nodes", (Iterable<NBTBase>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ForgeDirection.VALID_DIRECTIONS).map((Function1)new Serializable(tileEntity3){
                private final TileEntity x2$1;

                public final Node apply(ForgeDirection x$1) {
                    return ((SidedEnvironment)this.x2$1).sidedNode(x$1);
                }
                {
                    this.x2$1 = x2$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Node.class)))).map((Function1)new Serializable(tileEntity){
                private final TileEntity tileEntity$1;

                public final NBTTagCompound apply(Node x$1) {
                    return BlockDataProvider$.MODULE$.li$cil$oc$integration$waila$BlockDataProvider$$writeNode$1(x$1, new NBTTagCompound(), this.tileEntity$1);
                }
                {
                    this.tileEntity$1 = tileEntity$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NBTTagCompound.class)))));
        } else if (tileEntity2 instanceof Environment) {
            TileEntity tileEntity4 = tileEntity2;
            boxedUnit2 = this.li$cil$oc$integration$waila$BlockDataProvider$$writeNode$1(((Environment)tileEntity4).node(), tag, tileEntity);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        TileEntity tileEntity5 = tileEntity;
        if (tileEntity5 instanceof AccessPoint) {
            AccessPoint accessPoint = (AccessPoint)tileEntity5;
            tag.func_74780_a("signalStrength", accessPoint.strength());
            boxedUnit = ExtendedNBT$.MODULE$.extendNBTTagCompound(tag).setNewTagList("addresses", ExtendedNBT$.MODULE$.stringIterableToNbt((Iterable<String>)((Iterable)Predef$.MODULE$.refArrayOps((Object[])accessPoint.componentNodes()).map((Function1)new Serializable(){

                public final String apply(Component x$3) {
                    return x$3.address();
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())))));
        } else if (tileEntity5 instanceof Assembler) {
            BoxedUnit boxedUnit3;
            Assembler assembler = (Assembler)tileEntity5;
            this.ignoreSidedness$1(assembler.node(), tileEntity, tag);
            if (assembler.isAssembling()) {
                tag.func_74780_a("progress", assembler.progress());
                tag.func_74768_a("timeRemaining", assembler.timeRemaining());
                Option<ItemStack> option = assembler.output();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ItemStack output = (ItemStack)some.x();
                    tag.func_74778_a("output", output.func_77977_a());
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                }
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            boxedUnit = boxedUnit3;
        } else if (tileEntity5 instanceof Charger) {
            Charger charger = (Charger)tileEntity5;
            tag.func_74780_a("chargeSpeed", charger.chargeSpeed());
            boxedUnit = BoxedUnit.UNIT;
        } else if (tileEntity5 instanceof DiskDrive) {
            DiskDrive diskDrive = (DiskDrive)tileEntity5;
            tag.func_82580_o("address");
            diskDrive.filesystemNode().foreach((Function1)new Serializable(tileEntity, tag){
                private final TileEntity tileEntity$1;
                private final NBTTagCompound tag$1;

                public final NBTTagCompound apply(Node x$4) {
                    return BlockDataProvider$.MODULE$.li$cil$oc$integration$waila$BlockDataProvider$$writeNode$1(x$4, this.tag$1, this.tileEntity$1);
                }
                {
                    this.tileEntity$1 = tileEntity$1;
                    this.tag$1 = tag$1;
                }
            });
            boxedUnit = BoxedUnit.UNIT;
        } else if (tileEntity5 instanceof Hologram) {
            Hologram hologram = (Hologram)tileEntity5;
            this.ignoreSidedness$1(hologram.node(), tileEntity, tag);
            boxedUnit = BoxedUnit.UNIT;
        } else if (tileEntity5 instanceof Keyboard) {
            Keyboard keyboard = (Keyboard)tileEntity5;
            this.ignoreSidedness$1(keyboard.node(), tileEntity, tag);
            boxedUnit = BoxedUnit.UNIT;
        } else if (tileEntity5 instanceof Screen) {
            Screen screen = (Screen)tileEntity5;
            this.ignoreSidedness$1(screen.node(), tileEntity, tag);
            boxedUnit = BoxedUnit.UNIT;
        } else if (tileEntity5 instanceof Rack) {
            tag.func_82580_o("nodes");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return tag;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Object object;
        NBTTagCompound tag = accessor.getNBTData();
        if (tag == null || tag.func_82582_d()) {
            return tooltip;
        }
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof AccessPoint) {
            String address = tag.func_150295_c("addresses", 8).func_150307_f(accessor.getSide().ordinal());
            double signalStrength = tag.func_74769_h("signalStrength");
            Object object2 = config.getConfig(this.ConfigAddress()) ? BoxesRunTime.boxToBoolean((boolean)tooltip.add(Localization$Analyzer$.MODULE$.Address(address).func_150260_c())) : BoxedUnit.UNIT;
            object = BoxesRunTime.boxToBoolean((boolean)tooltip.add(Localization$Analyzer$.MODULE$.WirelessStrength(signalStrength).func_150260_c()));
        } else if (tileEntity instanceof Assembler) {
            Object object3;
            if (tag.func_74764_b("progress")) {
                double progress = tag.func_74769_h("progress");
                String timeRemaining = this.formatTime(tag.func_74762_e("timeRemaining"));
                tooltip.add(Localization$Assembler$.MODULE$.Progress(progress, timeRemaining));
                if (tag.func_74764_b("output")) {
                    String output = tag.func_74779_i("output");
                    object3 = BoxesRunTime.boxToBoolean((boolean)tooltip.add(new StringBuilder().append((Object)"Building: ").append((Object)Localization$.MODULE$.localizeImmediately(output)).toString()));
                } else {
                    object3 = BoxedUnit.UNIT;
                }
            } else {
                object3 = BoxedUnit.UNIT;
            }
            object = object3;
        } else if (tileEntity instanceof Charger) {
            double chargeSpeed = tag.func_74769_h("chargeSpeed");
            object = BoxesRunTime.boxToBoolean((boolean)tooltip.add(Localization$Analyzer$.MODULE$.ChargerSpeed(chargeSpeed).func_150260_c()));
        } else {
            object = tileEntity instanceof Rack ? BoxedUnit.UNIT : BoxedUnit.UNIT;
        }
        TileEntity tileEntity2 = accessor.getTileEntity();
        Object object4 = tileEntity2 instanceof SidedEnvironment ? this.readNode$1(tag.func_150295_c("nodes", 10).func_150305_b(accessor.getSide().ordinal()), tooltip, config) : (tileEntity2 instanceof Environment ? this.readNode$1(tag, tooltip, config) : BoxedUnit.UNIT);
        return tooltip;
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    private String formatTime(int seconds) {
        String string;
        if (seconds < 60) {
            int arg$macro$9 = seconds;
            string = new StringOps(Predef$.MODULE$.augmentString("0:%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$9)}));
        } else {
            Integer arg$macro$10 = BoxesRunTime.boxToInteger((int)(seconds / 60));
            int arg$macro$11 = seconds % 60;
            string = new StringOps(Predef$.MODULE$.augmentString("%s:%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$10, BoxesRunTime.boxToInteger((int)arg$macro$11)}));
        }
        return string;
    }

    public final NBTTagCompound li$cil$oc$integration$waila$BlockDataProvider$$writeNode$1(Node node2, NBTTagCompound tag, TileEntity tileEntity$1) {
        if (node2 != null) {
            Visibility visibility = node2.reachability();
            Visibility visibility2 = Visibility.None;
            if ((visibility == null ? visibility2 != null : !((Object)((Object)visibility)).equals((Object)visibility2)) && !(tileEntity$1 instanceof NotAnalyzable)) {
                Node node3;
                if (node2.address() != null) {
                    tag.func_74778_a("address", node2.address());
                }
                if ((node3 = node2) instanceof Connector) {
                    Connector connector = (Connector)node3;
                    tag.func_74768_a("buffer", (int)connector.localBuffer());
                    tag.func_74768_a("bufferSize", (int)connector.localBufferSize());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                Node node4 = node2;
                if (node4 instanceof Component) {
                    Component component = (Component)node4;
                    tag.func_74778_a("componentName", component.name());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        return tag;
    }

    private final void ignoreSidedness$1(Node node2, TileEntity tileEntity$1, NBTTagCompound tag$1) {
        tag$1.func_82580_o("nodes");
        NBTTagCompound nodeTag = this.li$cil$oc$integration$waila$BlockDataProvider$$writeNode$1(node2, new NBTTagCompound(), tileEntity$1);
        ExtendedNBT$.MODULE$.extendNBTTagCompound(tag$1).setNewTagList("nodes", (Iterable<NBTBase>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])ForgeDirection.VALID_DIRECTIONS).map((Function1)new Serializable(nodeTag){
            private final NBTTagCompound nodeTag$1;

            public final NBTTagCompound apply(ForgeDirection x$2) {
                return this.nodeTag$1;
            }
            {
                this.nodeTag$1 = nodeTag$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NBTTagCompound.class)))));
    }

    private final Object readNode$1(NBTTagCompound tag, List tooltip$1, IWailaConfigHandler config$1) {
        String componentName;
        Object object;
        String address;
        Object object2 = config$1.getConfig(this.ConfigAddress()) && tag.func_74764_b("address") ? (new StringOps(Predef$.MODULE$.augmentString(address = tag.func_74779_i("address"))).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)tooltip$1.add(Localization$Analyzer$.MODULE$.Address(address).func_150260_c())) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        if (config$1.getConfig(this.ConfigEnergy()) && tag.func_74764_b("buffer") && tag.func_74764_b("bufferSize")) {
            int buffer = tag.func_74762_e("buffer");
            int bufferSize = tag.func_74762_e("bufferSize");
            object = bufferSize > 0 ? BoxesRunTime.boxToBoolean((boolean)tooltip$1.add(Localization$Analyzer$.MODULE$.StoredEnergy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)buffer), BoxesRunTime.boxToInteger((int)bufferSize)}))).func_150260_c())) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return config$1.getConfig(this.ConfigComponentName()) && tag.func_74764_b("componentName") ? (new StringOps(Predef$.MODULE$.augmentString(componentName = tag.func_74779_i("componentName"))).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)tooltip$1.add(Localization$Analyzer$.MODULE$.ComponentName(componentName).func_150260_c())) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
    }

    private BlockDataProvider$() {
        MODULE$ = this;
        this.ConfigAddress = "oc.address";
        this.ConfigEnergy = "oc.energy";
        this.ConfigComponentName = "oc.componentName";
    }
}

