/*
 * Decompiled with CFR 0.152.
 */
package minechem.api;

import java.util.concurrent.atomic.AtomicBoolean;

class MinechemClassesAccess {
    static final Class classMoleculeEnum;
    static final Class classElementEnum;
    static final Class classElement;
    static final Class classMolecule;
    static final Class classChemicalRoomStateEnum;
    static final Class classArrayPotionChemical;
    static final Class classPotionChemical;
    static final Class classChemicalFluidReactionHandler;
    static final Class classChemicalFluidReactionOutput;
    static final Class classChemicalFluidReactionRule;
    static final Class classMinechemChemicalType;
    static final Class classDecomposerRecipe;
    static final Class classSynthesisRecipe;
    static final Class classDecomposerFluidRecipe;
    static final boolean isMinechemInstalled;

    private MinechemClassesAccess() {
    }

    private static Class getClassSafely(String className, AtomicBoolean isInstalled) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            isInstalled.set(false);
            return null;
        }
    }

    static {
        AtomicBoolean isInstalled = new AtomicBoolean(true);
        classMoleculeEnum = MinechemClassesAccess.getClassSafely("minechem.item.molecule.MoleculeEnum", isInstalled);
        classElementEnum = MinechemClassesAccess.getClassSafely("minechem.item.element.ElementEnum", isInstalled);
        classElement = MinechemClassesAccess.getClassSafely("minechem.item.element.Element", isInstalled);
        classMolecule = MinechemClassesAccess.getClassSafely("minechem.item.molecule.Molecule", isInstalled);
        classChemicalRoomStateEnum = MinechemClassesAccess.getClassSafely("minechem.item.ChemicalRoomStateEnum", isInstalled);
        classPotionChemical = MinechemClassesAccess.getClassSafely("minechem.potion.PotionChemical", isInstalled);
        classArrayPotionChemical = MinechemClassesAccess.getClassSafely("[Lminechem.potion.PotionChemical;", isInstalled);
        classChemicalFluidReactionHandler = MinechemClassesAccess.getClassSafely("minechem.fluid.reaction.ChemicalFluidReactionHandler", isInstalled);
        classChemicalFluidReactionOutput = MinechemClassesAccess.getClassSafely("minechem.fluid.reaction.ChemicalFluidReactionOutput", isInstalled);
        classChemicalFluidReactionRule = MinechemClassesAccess.getClassSafely("minechem.fluid.reaction.ChemicalFluidReactionRule", isInstalled);
        classMinechemChemicalType = MinechemClassesAccess.getClassSafely("minechem.item.MinechemChemicalType", isInstalled);
        classDecomposerRecipe = MinechemClassesAccess.getClassSafely("minechem.tileentity.decomposer.DecomposerRecipe", isInstalled);
        classSynthesisRecipe = MinechemClassesAccess.getClassSafely("minechem.tileentity.synthesis.SynthesisRecipe", isInstalled);
        classDecomposerFluidRecipe = MinechemClassesAccess.getClassSafely("minechem.tileentity.decomposer.DecomposerFluidRecipe", isInstalled);
        isMinechemInstalled = isInstalled.get();
    }
}

