/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementMouseClick;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class StatementBase
implements ITriggerExternal {
    private final String id;
    private IIcon icon;
    private String iconstring;
    private final Class[] argTypes;
    protected static final String questionIcon = "dragonapi:modinteract/question";
    private static final HashMap<Class, Constructor> constructors = new HashMap();

    public StatementBase(String name, Class ... args) {
        this(name, name, new Class[0]);
    }

    public StatementBase(String name, String ico, Class ... args) {
        this.id = name;
        this.iconstring = ico;
        this.argTypes = args;
    }

    public final String getUniqueTag() {
        return this.id;
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon getIcon() {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerIcons(IIconRegister ico) {
        this.icon = ico.func_94245_a(this.iconstring);
    }

    public IStatement rotateLeft() {
        return this;
    }

    protected abstract int getArgCount();

    public final int maxParameters() {
        return this.getArgCount();
    }

    public final int minParameters() {
        return this.getArgCount();
    }

    public final IStatementParameter createParameter(int index) {
        return StatementBase.createArgument(this.argTypes[index], this);
    }

    private static StatementArgument createArgument(Class<? extends StatementArgument> type, StatementBase func) {
        try {
            Constructor<? extends StatementArgument> c = constructors.get(type);
            if (c == null) {
                c = type.getConstructor(StatementBase.class);
                constructors.put(type, c);
            }
            return (StatementArgument)c.newInstance(func);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final boolean isTriggerActive(TileEntity target, ForgeDirection side, IStatementContainer source, IStatementParameter[] parameters) {
        return this.evaluate(target, side, source.getTile(), parameters);
    }

    protected abstract boolean evaluate(TileEntity var1, ForgeDirection var2, TileEntity var3, IStatementParameter[] var4);

    public static abstract class ArgumentState {
        @SideOnly(value=Side.CLIENT)
        public abstract IIcon getIcon();

        @SideOnly(value=Side.CLIENT)
        public abstract void registerIcon(IIconRegister var1);

        public abstract String getDesc();
    }

    public static final class StateArgument
    extends StatementArgument {
        private final ArrayList<ArgumentState> states = new ArrayList();
        private int index;

        public StateArgument(StatementBase func) {
            super("stock:states", func);
        }

        public StateArgument addState(ArgumentState e) {
            this.states.add(e);
            return this;
        }

        public String getDescription() {
            return this.activeState().getDesc();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IIcon getIcon() {
            return this.activeState().getIcon();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void registerIcons(IIconRegister ico) {
            for (ArgumentState a : this.states) {
                a.registerIcon(ico);
            }
        }

        public ArgumentState activeState() {
            return this.states.get(this.index);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.index = tag.func_74762_e("idx");
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("idx", this.index);
        }

        @Override
        protected void onClick(TileEntity caller, ItemStack held, int button, boolean shift) {
            if (this.states.isEmpty()) {
                return;
            }
            int i = button == 0 ? 1 : -1;
            int offset = this.index + i;
            this.index = offset < 0 ? this.states.size() - 1 : (offset >= this.states.size() ? 0 : offset);
        }
    }

    public static class StackArgument
    extends StatementArgument {
        private ItemStack stack;

        public StackArgument(StatementBase func) {
            super("stock:stack", func);
        }

        public String getDescription() {
            return this.stack != null ? "Empty" : this.stack.func_82833_r();
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.stack = tag.func_74767_n("hasStack") ? ItemStack.func_77949_a((NBTTagCompound)tag) : null;
        }

        public void writeToNBT(NBTTagCompound tag) {
            if (this.stack != null) {
                this.stack.func_77955_b(tag);
                tag.func_74757_a("hasStack", true);
            } else {
                tag.func_74757_a("hasStack", false);
            }
        }

        @Override
        protected void onClick(TileEntity caller, ItemStack held, int button, boolean shift) {
            this.stack = held != null ? held.func_77946_l() : null;
        }

        @Override
        public final ItemStack getItemStack() {
            return this.stack;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IIcon getIcon() {
            return this.stack != null ? this.stack.func_77954_c() : null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void registerIcons(IIconRegister ico) {
        }
    }

    public static abstract class StatementArgument
    implements IStatementParameter {
        private final String id;
        private IIcon icon;
        private String iconstring;
        protected final StatementBase function;

        protected StatementArgument(String name, StatementBase func) {
            this.iconstring = this.id = name;
            this.function = func;
        }

        public final String getUniqueTag() {
            return this.id;
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon getIcon() {
            return this.icon;
        }

        @SideOnly(value=Side.CLIENT)
        public void registerIcons(IIconRegister ico) {
            this.icon = ico.func_94245_a(this.iconstring);
        }

        public ItemStack getItemStack() {
            return null;
        }

        public final void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
            this.onClick(source.getTile(), stack, mouse.getButton(), mouse.isShift());
        }

        protected void onClick(TileEntity caller, ItemStack held, int button, boolean shift) {
        }

        public IStatementParameter rotateLeft() {
            return null;
        }
    }
}

