/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Interfaces.Registry.RegistrationList;
import Reika.DragonAPI.Interfaces.Registry.RegistryEntry;
import Reika.DragonAPI.Libraries.ReikaRegistryHelper;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Method;
import moze_intel.projecte.api.ProjectEAPI;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ReikaEEHelper {
    private static Method configRemove;

    public static void blacklistItemStack(ItemStack is) {
        if (!ReikaEEHelper.isLoaded()) {
            return;
        }
        if (ModList.PROJECTE.isLoaded()) {
            ReikaEEHelper.registerCustomEMC(is, 0);
            ReikaEEHelper.removeFromConfig(is);
        }
    }

    public static void blacklistBlock(Block item) {
        if (!ReikaEEHelper.isLoaded()) {
            return;
        }
        RegistryEntry e = ReikaRegistryHelper.getRegistryForObject(item);
        if (e instanceof RegistrationList) {
            ReikaEEHelper.blacklistEntry((RegistrationList)e);
        } else {
            for (int i = 0; i < 32768; ++i) {
                ReikaEEHelper.blacklistItemStack(new ItemStack(item, 1, i));
            }
        }
    }

    public static void blacklistItem(Item item) {
        if (!ReikaEEHelper.isLoaded()) {
            return;
        }
        RegistryEntry e = ReikaRegistryHelper.getRegistryForObject(item);
        if (e instanceof RegistrationList) {
            ReikaEEHelper.blacklistEntry((RegistrationList)e);
        } else {
            for (int i = 0; i < 32768; ++i) {
                ReikaEEHelper.blacklistItemStack(new ItemStack(item, 1, i));
            }
        }
    }

    public static void blacklistEntry(RegistrationList reg) {
        if (!ReikaEEHelper.isLoaded()) {
            return;
        }
        for (int i = 0; i < reg.getNumberMetadatas(); ++i) {
            ReikaEEHelper.blacklistItemStack(reg.getStackOfMetadata(i));
        }
    }

    public static void blacklistRegistry(RegistrationList[] reg) {
        if (!ReikaEEHelper.isLoaded()) {
            return;
        }
        for (int i = 0; i < reg.length; ++i) {
            ReikaEEHelper.blacklistEntry(reg[i]);
        }
    }

    public static boolean isLoaded() {
        return ModList.PROJECTE.isLoaded();
    }

    public static void registerCustomEMC(ItemStack is, int emc) {
        if (!ModList.PROJECTE.isLoaded()) {
            try {
                ProjectEAPI.getEMCProxy().registerCustomEMC(is, emc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void removeFromConfig(ItemStack is) {
        try {
            configRemove.invoke(null, Item.field_150901_e.func_148750_c((Object)is.func_77973_b()), is.func_77960_j());
        }
        catch (Exception e) {
            ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.PROJECTE, e);
        }
    }

    static {
        if (ModList.PROJECTE.isLoaded()) {
            try {
                Class<?> c = Class.forName("moze_intel.projecte.config.CustomEMCParser");
                configRemove = c.getDeclaredMethod("removeFromFile", String.class, Integer.TYPE);
                configRemove.setAccessible(true);
            }
            catch (Exception e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.PROJECTE, e);
            }
        }
    }
}

