/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.RecipeHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Collections.ChancedOutputList;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.Collection;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ForestryRecipeHelper
extends ModHandlerBase {
    private static final ForestryRecipeHelper instance = new ForestryRecipeHelper();
    private final ItemHashMap<ChancedOutputList> centrifuge = new ItemHashMap();
    private final ItemHashMap<ImmutablePair<ChancedOutputList, FluidStack>> squeezer = new ItemHashMap();

    public static final ForestryRecipeHelper getInstance() {
        return instance;
    }

    private ForestryRecipeHelper() {
        if (this.hasMod()) {
            if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
                throw new MisuseException("You cannot load other mod's machine recipes before postload!");
            }
            try {
                Collection c = RecipeManagers.centrifugeManager.recipes();
                for (ICentrifugeRecipe r : c) {
                    ItemStack in = r.getInput();
                    ChancedOutputList outputs = new ChancedOutputList(false);
                    Map out = r.getAllProducts();
                    for (ItemStack is : out.keySet()) {
                        float chance = ((Float)out.get(is)).floatValue() * 100.0f;
                        for (int i = 0; i < is.field_77994_a; ++i) {
                            outputs.addItem(ReikaItemHelper.getSizedItemStack(is, 1), chance);
                        }
                    }
                    this.centrifuge.put(in, outputs);
                }
                for (ISqueezerRecipe in : RecipeManagers.squeezerManager.recipes()) {
                    ItemStack[] items = in.getResources();
                    if (items.length != 1 || FluidContainerRegistry.isFilledContainer((ItemStack)items[0])) continue;
                    ChancedOutputList out = null;
                    if (in.getRemnants() != null) {
                        out = new ChancedOutputList(false);
                        out.addItem(in.getRemnants(), in.getRemnantsChance() * 100.0f);
                    }
                    FluidStack fs = in.getFluidOutput();
                    this.squeezer.put(items[0], (ImmutablePair<ChancedOutputList, FluidStack>)new ImmutablePair((Object)out, (Object)fs));
                }
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not initialize Forestry recipe helper!");
                e.printStackTrace();
            }
        } else {
            this.noMod();
        }
    }

    public Collection<ItemStack> getCentrifugeRecipes() {
        return this.centrifuge.keySet();
    }

    public Collection<ItemStack> getSqueezerRecipes() {
        return this.squeezer.keySet();
    }

    public ChancedOutputList getCentrifugeOutput(ItemStack in) {
        return this.centrifuge.get(in).copy();
    }

    public ImmutablePair<ChancedOutputList, FluidStack> getSqueezerOutput(ItemStack in) {
        return this.squeezer.get(in);
    }

    @Override
    public boolean initializedProperly() {
        return !this.centrifuge.isEmpty() && !this.squeezer.isEmpty();
    }

    @Override
    public ModList getMod() {
        return ModList.FORESTRY;
    }
}

