/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Lua;

import Reika.DragonAPI.ModInteract.Lua.Library.LuaFluidColor;
import Reika.DragonAPI.ModInteract.Lua.Library.LuaGetBlock;
import Reika.DragonAPI.ModInteract.Lua.LuaGetCoords;
import Reika.DragonAPI.ModInteract.Lua.LuaGetNBTTag;
import Reika.DragonAPI.ModInteract.Lua.LuaGetPlacer;
import Reika.DragonAPI.ModInteract.Lua.LuaGetRFCapacity;
import Reika.DragonAPI.ModInteract.Lua.LuaGetSlot;
import Reika.DragonAPI.ModInteract.Lua.LuaGetStoredRF;
import Reika.DragonAPI.ModInteract.Lua.LuaGetTanks;
import Reika.DragonAPI.ModInteract.Lua.LuaHasItem;
import Reika.DragonAPI.ModInteract.Lua.LuaInvSize;
import Reika.DragonAPI.ModInteract.Lua.LuaIsFull;
import Reika.DragonAPI.ModInteract.Lua.LuaIsTankFull;
import Reika.DragonAPI.ModInteract.Lua.LuaPrintInv;
import Reika.DragonAPI.ModInteract.Lua.LuaReadTank;
import Reika.DragonAPI.ModInteract.Lua.LuaTriggerAction;
import Reika.DragonAPI.ModRegistry.PowerTypes;
import dan200.computercraft.api.lua.LuaException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;

public abstract class LuaMethod {
    public final String displayName;
    private final Class requiredClass;
    private static final Collection<LuaMethod> methods = new HashSet<LuaMethod>();
    private static final LuaMethod tanks = new LuaGetTanks();
    private static final LuaMethod readTank = new LuaReadTank();
    private static final LuaMethod getSlot = new LuaGetSlot();
    private static final LuaMethod getSizeInv = new LuaInvSize();
    private static final LuaMethod printInv = new LuaPrintInv();
    private static final LuaMethod getCoords = new LuaGetCoords();
    private static final LuaMethod isFull = new LuaIsFull();
    private static final LuaMethod isTankFull = new LuaIsTankFull();
    private static final LuaMethod hasItem = new LuaHasItem();
    private static final LuaMethod trigger = new LuaTriggerAction();
    private static final LuaMethod placer = new LuaGetPlacer();
    private static final LuaMethod nbt = new LuaGetNBTTag();
    private static final LuaMethod getRFStorage;
    private static final LuaMethod getRFCapacity;
    private static final LuaMethod fluidColor;
    private static final LuaMethod getBlock;

    public LuaMethod(String name, Class requiredParent) {
        this.displayName = name;
        this.requiredClass = requiredParent;
        if (methods.contains(this)) {
            throw new IllegalArgumentException("This method is a duplicate of one that already exists!");
        }
        methods.add(this);
    }

    public static final Collection<LuaMethod> getMethods() {
        return Collections.unmodifiableCollection(methods);
    }

    public static final int getNumberMethods() {
        return methods.size();
    }

    public abstract Object[] invoke(TileEntity var1, Object[] var2) throws LuaException, InterruptedException;

    public abstract String getDocumentation();

    public boolean isDocumented() {
        return true;
    }

    public final boolean isClassInstanceOf(Class<? extends TileEntity> te) {
        return this.requiredClass != null ? this.requiredClass.isAssignableFrom(te) : true;
    }

    public final boolean isValidFor(TileEntity te) {
        return this.requiredClass != null ? this.requiredClass.isAssignableFrom(te.getClass()) : true;
    }

    public final boolean equals(Object o) {
        if (o instanceof LuaMethod) {
            return ((LuaMethod)o).displayName.equals(this.displayName) && this.requiredClass == ((LuaMethod)o).requiredClass;
        }
        return false;
    }

    public final String toString() {
        String name = this.requiredClass != null ? this.requiredClass.getSimpleName() : "Any TileEntity";
        return this.displayName + "() for " + name;
    }

    public abstract String getArgsAsString();

    public abstract ReturnType getReturnType();

    static {
        fluidColor = new LuaFluidColor();
        getBlock = new LuaGetBlock();
        if (PowerTypes.RF.isLoaded()) {
            getRFStorage = new LuaGetStoredRF();
            getRFCapacity = new LuaGetRFCapacity();
        } else {
            getRFStorage = null;
            getRFCapacity = null;
        }
    }

    public static enum ReturnType {
        VOID("void"),
        INTEGER("int"),
        LONG("long"),
        ARRAY("Object[]"),
        STRING("String"),
        BOOLEAN("boolean"),
        FLOAT("float");

        public final String displayName;

        private ReturnType(String name) {
            this.displayName = name;
        }
    }
}

