/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class MagicaOreHandler
extends ModHandlerBase {
    public final Block oreID;
    public final Item itemID;
    public final int metaVinteum = 0;
    public final int metaChimerite = 1;
    public final int metaTopaz = 2;
    public final int metaMoonstone = 3;
    public final int metaSunstone = 4;
    public final int metaChimeriteItem = 4;
    public final int metaVinteumItem = 0;
    public final int metaTopazItem = 5;
    public final int metaMoonstoneItem = 7;
    public final int metaSunstoneItem = 6;
    private final ItemStack oreChimerite;
    private final ItemStack oreVinteum;
    private final ItemStack oreTopaz;
    private final ItemStack oreMoonstone;
    private final ItemStack oreSunstone;
    private final ItemStack itemChimerite;
    private final ItemStack itemVinteum;
    private final ItemStack itemTopaz;
    private final ItemStack itemMoonstone;
    private final ItemStack itemSunstone;
    private final ArrayList ores = new ArrayList();
    private final ArrayList items = new ArrayList();
    private boolean isOreDict = false;
    private static final MagicaOreHandler instance = new MagicaOreHandler();

    private MagicaOreHandler() {
        Block idore = null;
        Item iditem = null;
        if (this.hasMod()) {
            try {
                Class blocks = ModList.ARSMAGICA.getBlockClass();
                Class items = ModList.ARSMAGICA.getItemClass();
                Field ore = blocks.getField("AMOres");
                Field item = items.getField("itemOre");
                Block oreb = (Block)ore.get(null);
                Item itemi = (Item)item.get(null);
                idore = oreb;
                iditem = itemi;
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.oreID = idore;
        this.itemID = iditem;
        this.oreChimerite = new ItemStack(this.oreID, 1, 1);
        this.oreTopaz = new ItemStack(this.oreID, 1, 2);
        this.oreSunstone = new ItemStack(this.oreID, 1, 4);
        this.oreVinteum = new ItemStack(this.oreID, 1, 0);
        this.oreMoonstone = new ItemStack(this.oreID, 1, 3);
        this.ores.add(this.oreChimerite);
        this.ores.add(this.oreTopaz);
        this.ores.add(this.oreSunstone);
        this.ores.add(this.oreVinteum);
        this.ores.add(this.oreMoonstone);
        this.itemTopaz = new ItemStack(this.itemID, 1, 5);
        this.itemSunstone = new ItemStack(this.itemID, 1, 6);
        this.itemVinteum = new ItemStack(this.itemID, 1, 0);
        this.itemMoonstone = new ItemStack(this.itemID, 1, 7);
        this.itemChimerite = new ItemStack(this.itemID, 1, 4);
        this.items.add(this.itemTopaz);
        this.items.add(this.itemSunstone);
        this.items.add(this.itemVinteum);
        this.items.add(this.itemMoonstone);
        this.items.add(this.itemChimerite);
    }

    public static MagicaOreHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.oreID != null && this.itemID != null;
    }

    @Override
    public ModList getMod() {
        return ModList.ARSMAGICA;
    }

    public ItemStack getOre(int meta) {
        if (!this.initializedProperly()) {
            return null;
        }
        switch (meta) {
            case 0: {
                return this.oreVinteum.func_77946_l();
            }
            case 1: {
                return this.oreChimerite.func_77946_l();
            }
            case 2: {
                return this.oreTopaz.func_77946_l();
            }
            case 3: {
                return this.oreMoonstone.func_77946_l();
            }
            case 4: {
                return this.oreSunstone.func_77946_l();
            }
        }
        return null;
    }

    public ItemStack getItem(int meta) {
        if (!this.initializedProperly()) {
            return null;
        }
        switch (meta) {
            case 5: {
                return this.itemTopaz.func_77946_l();
            }
            case 7: {
                return this.itemMoonstone.func_77946_l();
            }
            case 6: {
                return this.itemSunstone.func_77946_l();
            }
            case 4: {
                return this.itemChimerite.func_77946_l();
            }
            case 0: {
                return this.itemVinteum.func_77946_l();
            }
        }
        return null;
    }

    public ItemStack getOre(ModOreList ore) {
        if (!this.initializedProperly()) {
            return null;
        }
        switch (ore) {
            case VINTEUM: {
                return this.oreVinteum.func_77946_l();
            }
            case CHIMERITE: {
                return this.oreChimerite.func_77946_l();
            }
            case BLUETOPAZ: {
                return this.oreTopaz.func_77946_l();
            }
            case MOONSTONE: {
                return this.oreMoonstone.func_77946_l();
            }
            case SUNSTONE: {
                return this.oreSunstone.func_77946_l();
            }
        }
        return null;
    }

    public ItemStack getItem(ModOreList ore) {
        if (!this.initializedProperly()) {
            return null;
        }
        switch (ore) {
            case BLUETOPAZ: {
                return this.itemTopaz.func_77946_l();
            }
            case CHIMERITE: {
                return this.itemChimerite.func_77946_l();
            }
            case MOONSTONE: {
                return this.itemMoonstone.func_77946_l();
            }
            case SUNSTONE: {
                return this.itemSunstone.func_77946_l();
            }
            case VINTEUM: {
                return this.itemVinteum.func_77946_l();
            }
        }
        return null;
    }

    public boolean isArsMagicaOre(ItemStack is) {
        if (!this.initializedProperly()) {
            return false;
        }
        if (is == null) {
            return false;
        }
        return Block.func_149634_a((Item)is.func_77973_b()) == this.oreID;
    }

    public boolean isItem(ItemStack is) {
        if (!this.initializedProperly()) {
            return false;
        }
        return is.func_77973_b() == this.itemID;
    }

    public void forceOreRegistration() {
        if (!this.isOreDict) {
            DragonAPICore.log("Ars Magica ores are being registered to Ore Dictionary!");
            for (int i = 0; i < ModOreList.oreList.length; ++i) {
                ModOreList o = ModOreList.oreList[i];
                if (!o.isArsMagica()) continue;
                OreDictionary.registerOre((String)o.getOreDictNames()[0], (ItemStack)this.getOre(o));
                OreDictionary.registerOre((String)o.getProductOreDictName(), (ItemStack)this.getItem(o));
                o.initialize();
                DragonAPICore.log("Registering " + o.displayName);
            }
        } else {
            DragonAPICore.log("Ars Magica ores already registered to ore dictionary! No action taken!");
            ReikaJavaLibrary.dumpStack();
        }
    }
}

