/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import net.minecraft.block.Block;

public class ChiselBlockHandler
extends ModHandlerBase {
    private boolean init = false;
    private static final ChiselBlockHandler instance = new ChiselBlockHandler();

    private ChiselBlockHandler() {
        int metabreaker = -1;
        int dim = 7;
        if (this.hasMod()) {
            Class block = this.getMod().getBlockClass();
            Class items = this.getMod().getItemClass();
            for (int i = 0; i < BlockEntry.list.length; ++i) {
                BlockEntry b = BlockEntry.list[i];
                try {
                    Field f = block.getField(b.tag);
                    b.block = (Block)f.get(null);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (SecurityException e) {
                    DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                }
            }
            this.init = true;
        } else {
            this.noMod();
        }
    }

    public static ChiselBlockHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.init;
    }

    @Override
    public ModList getMod() {
        return ModList.CHISEL;
    }

    public static boolean isWorldgenBlock(Block b, int meta) {
        if (meta != 0) {
            return false;
        }
        return b == BlockEntry.MARBLE.getBlock() || b == BlockEntry.SANDSTONE.getBlock() || b == BlockEntry.LIMESTONE.getBlock() || b == BlockEntry.GRANITE.getBlock() || b == BlockEntry.DIORITE.getBlock() || b == BlockEntry.ANDESITE.getBlock();
    }

    public static enum BlockEntry {
        MARBLE("marble"),
        SANDSTONE("sandstone"),
        LIMESTONE("limestone"),
        GRANITE("granite"),
        DIORITE("diorite"),
        ANDESITE("andesite");

        private final String tag;
        private Block block;
        private static final BlockEntry[] list;

        private BlockEntry(String s) {
            this.tag = s;
        }

        public Block getBlock() {
            return this.block;
        }

        static {
            list = BlockEntry.values();
        }
    }
}

