/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class BotaniaBlockHandler
extends ModHandlerBase {
    private static final BotaniaBlockHandler instance = new BotaniaBlockHandler();
    public final Block flowerID;
    public final Block livingRockID;
    public final Block livingWoodID;

    private BotaniaBlockHandler() {
        Block idflower = null;
        Block idlivingrock = null;
        Block idlivingwood = null;
        if (this.hasMod()) {
            try {
                Class blocks = this.getMod().getBlockClass();
                Field f = blocks.getField("flower");
                idflower = (Block)f.get(null);
                f = blocks.getField("livingrock");
                idlivingrock = (Block)f.get(null);
                f = blocks.getField("livingwood");
                idlivingwood = (Block)f.get(null);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.livingRockID = idlivingrock;
        this.livingWoodID = idlivingwood;
        this.flowerID = idflower;
    }

    public static BotaniaBlockHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.livingRockID != null && this.livingWoodID != null && this.flowerID != null;
    }

    @Override
    public ModList getMod() {
        return ModList.BOTANIA;
    }

    public boolean isMysticalFlower(ItemStack block) {
        if (!this.initializedProperly()) {
            return false;
        }
        return ReikaItemHelper.matchStackWithBlock(block, this.flowerID);
    }
}

