/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TinkerSmelteryHandler {
    private static Class tileClass;
    private static Field fuel;
    private static Field temperatures;
    private static Field internal;
    private static Field use;
    private static Field use2;
    private static Field tank;
    private static Field tanks;
    private static Class coord;
    private static Field coordX;
    private static Field coordY;
    private static Field coordZ;

    public static boolean isSmelteryController(TileEntity te) {
        return te != null && te.getClass() == tileClass;
    }

    public static IFluidHandler getActiveTank(TileEntity te) {
        try {
            Object coord = tank.get(te);
            if (coord == null) {
                for (Object o : (ArrayList)tanks.get(te)) {
                    if (o == null || o.getClass() != coord) continue;
                    coord = o;
                    break;
                }
            }
            if (coord == null) {
                return null;
            }
            int x = coordX.getInt(coord);
            int y = coordY.getInt(coord);
            int z = coordZ.getInt(coord);
            return (IFluidHandler)te.field_145850_b.func_147438_o(x, y, z);
        }
        catch (Exception e) {
            DragonAPICore.logError("Error running Smeltery Handling!");
            e.printStackTrace();
            ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
            return null;
        }
    }

    public static void tick(TileEntity te, int temp) {
        IFluidHandler ifl = TinkerSmelteryHandler.getActiveTank(te);
        if (ifl != null) {
            ifl.fill(ForgeDirection.UP, new FluidStack(FluidRegistry.LAVA, 15), true);
        }
        te.func_70296_d();
        te.func_145845_h();
    }

    static {
        if (ModList.TINKERER.isLoaded()) {
            try {
                tileClass = Class.forName("tconstruct.smeltery.logic.SmelteryLogic");
                fuel = tileClass.getDeclaredField("fuelAmount");
                fuel.setAccessible(true);
                temperatures = tileClass.getDeclaredField("activeTemps");
                temperatures.setAccessible(true);
                internal = tileClass.getDeclaredField("internalTemp");
                internal.setAccessible(true);
                use = tileClass.getDeclaredField("useTime");
                use.setAccessible(true);
                use2 = tileClass.getDeclaredField("inUse");
                use2.setAccessible(true);
                tank = tileClass.getDeclaredField("activeLavaTank");
                tank.setAccessible(true);
                tanks = tileClass.getDeclaredField("lavaTanks");
                tanks.setAccessible(true);
                coord = Class.forName("mantle.world.CoordTuple");
                coordX = coord.getDeclaredField("x");
                coordX.setAccessible(true);
                coordY = coord.getDeclaredField("y");
                coordY.setAccessible(true);
                coordZ = coord.getDeclaredField("z");
                coordZ.setAccessible(true);
            }
            catch (Exception e) {
                DragonAPICore.logError("Error loading Smeltery Handling!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
            }
        }
    }

    public static class SmelteryWrapper {
        public int[] currentTemperatures;
        public int meltPower;
        public int fuelLevel;
        private final long tileID;

        public SmelteryWrapper(TileEntity te) {
            if (!TinkerSmelteryHandler.isSmelteryController(te)) {
                throw new MisuseException("Tile is not a smeltery!");
            }
            this.tileID = System.identityHashCode(te);
            this.load(te);
        }

        public void load(TileEntity te) {
            if ((long)System.identityHashCode(te) != this.tileID) {
                throw new MisuseException("You cannot reuse a SmelteryWrapper instance for different TileEntities!");
            }
            try {
                this.currentTemperatures = (int[])temperatures.get(te);
                this.meltPower = internal.getInt(te);
                this.fuelLevel = fuel.getInt(te);
            }
            catch (Exception e) {
                DragonAPICore.logError("Error running Smeltery Handling!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
            }
        }

        public void write(TileEntity te) {
            if ((long)System.identityHashCode(te) != this.tileID) {
                throw new MisuseException("You cannot reuse a SmelteryWrapper instance for different TileEntities!");
            }
            try {
                temperatures.set(te, this.currentTemperatures);
                internal.setInt(te, this.meltPower);
                fuel.setInt(te, this.fuelLevel);
                if (this.fuelLevel > 0) {
                    use.setInt(te, Math.max(8, use.getInt(te)));
                    use2.setBoolean(te, true);
                }
                te.func_70296_d();
                Method m = tileClass.getDeclaredMethod("heatItems", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)te, new Object[0]);
            }
            catch (Exception e) {
                DragonAPICore.logError("Error running Smeltery Handling!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
            }
        }
    }
}

