/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Instantiable.Data.Immutable.ImmutableArray;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public final class SensitiveFluidRegistry {
    public static final SensitiveFluidRegistry instance = new SensitiveFluidRegistry();
    private final OneWayCollections.OneWaySet<Fluid> forbiddenFluids = new OneWayCollections.OneWaySet();
    private Class fluidCowClass;
    private Field fluidCowField;

    private SensitiveFluidRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            this.fluidCowClass = Class.forName("com.robrit.moofluids.common.entity.EntityFluidCow");
            this.fluidCowField = this.fluidCowClass.getDeclaredField("entityFluid");
            this.fluidCowField.setAccessible(true);
        }
        catch (Exception e) {
            DragonAPICore.log("MooFluids not detected. Not loading fluid handling.");
        }
    }

    public void registerFluid(String fluid) {
        this.registerFluid(FluidRegistry.getFluid((String)fluid));
    }

    public void registerFluid(Fluid fluid) {
        for (int i = 0; i < Interactions.list.length; ++i) {
            Interactions it = (Interactions)((Object)Interactions.list.get(i));
            if (!it.isLoaded) continue;
            it.blacklist(fluid);
        }
        this.forbiddenFluids.add(fluid);
    }

    @SubscribeEvent
    public void stopCows(EntityJoinWorldEvent evt) {
        Fluid f;
        Entity e = evt.entity;
        if (e.getClass() == this.fluidCowClass && this.forbiddenFluids.contains(f = this.getCowFluid(e))) {
            evt.setCanceled(true);
            EntityCow repl = new EntityCow(evt.world);
            repl.func_70012_b(e.field_70165_t, e.field_70163_u, e.field_70161_v, e.field_70177_z, e.field_70125_A);
            repl.func_70606_j(((EntityCow)e).func_110143_aJ());
            repl.func_70873_a(((EntityCow)e).func_70874_b());
            evt.world.func_72838_d((Entity)repl);
        }
    }

    private Fluid getCowFluid(Entity e) {
        try {
            return (Fluid)this.fluidCowField.get(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean contains(Fluid f) {
        return this.forbiddenFluids.contains(f);
    }

    private static enum Interactions {
        MYSTCRAFT(ModList.MYSTCRAFT.isLoaded()),
        MOOFLUID(Loader.isModLoaded((String)"MooFluids")),
        RFTOOLS(Loader.isModLoaded((String)"rftools"));

        private final boolean isLoaded;
        private static final ImmutableArray<Interactions> list;

        private Interactions(boolean b) {
            this.isLoaded = b;
        }

        private void blacklist(Fluid fluid) {
            switch (this) {
                case MYSTCRAFT: {
                    ReikaMystcraftHelper.disableFluidPage(fluid);
                    break;
                }
                case MOOFLUID: {
                    break;
                }
                case RFTOOLS: {
                    FMLInterModComms.sendMessage((String)"rftools", (String)"dimlet_blacklist", (String)("Liquid." + fluid.getName()));
                }
            }
        }

        static {
            list = new ImmutableArray<Interactions>(Interactions.values());
        }
    }
}

