/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract;

import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class BannedItemReader {
    public static final BannedItemReader instance = new BannedItemReader();
    private final OneWayCollections.OneWaySet<KeyedItemStack> allEntries = new OneWayCollections.OneWaySet();
    public static final String PLUGIN_PATH = System.getProperty("user.dir").replaceAll("\\\\", "/") + "/plugins/";

    private BannedItemReader() {
    }

    public void initWith(String dir, String file) {
        if (file.equals("*")) {
            File f = new File(dir);
            if (f.exists() && f.isDirectory()) {
                try {
                    this.parseDirectory(f);
                }
                catch (Exception exception) {}
            }
        } else {
            File f = new File(dir, file);
            if (f.exists() && !f.isDirectory()) {
                try {
                    this.parseFile(f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean containsID(Block id) {
        return this.containsItem(new ItemStack(id, 1, Short.MAX_VALUE));
    }

    public boolean containsID(Item item) {
        return this.containsItem(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public boolean containsItem(ItemStack is) {
        return this.allEntries.contains(this.createKey(is));
    }

    private KeyedItemStack createKey(ItemStack is) {
        return new KeyedItemStack(is).setSimpleHash(true).setIgnoreNBT(true).setSized(false);
    }

    private void parseDirectory(File f) throws Exception {
        ArrayList<File> li = ReikaFileReader.getAllFilesInFolder(f, "yml", "txt", "dat", "cfg", "json");
        for (File in : li) {
            this.parseFile(in);
        }
    }

    private void parseFile(File f) throws Exception {
        if (f.getName().endsWith("json")) {
            this.parseJSONFile(f);
        } else {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            String line = in.readLine();
            while (line != null) {
                String[] parts;
                String oline = line;
                boolean flag = false;
                while (!line.isEmpty() && !Character.isDigit(line.charAt(0))) {
                    line = line.substring(1);
                }
                if (!line.isEmpty() && (parts = line.split(":")) != null && parts.length > 1) {
                    try {
                        String id = parts[0];
                        String meta = parts[1];
                        try {
                            int intid = Integer.parseInt(id);
                            int intmeta = meta.equals("*") ? -1 : Integer.parseInt(meta);
                            Item item = Item.func_150899_d((int)intid);
                            this.allEntries.add(intmeta >= 0 ? this.createKey(new ItemStack(item, intmeta)) : this.createKey(new ItemStack(item)));
                            flag = true;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!flag && !oline.isEmpty()) {
                    this.allEntries.add(this.createKey(ReikaItemHelper.lookupItem(oline)));
                }
                line = in.readLine();
            }
            in.close();
        }
    }

    private void parseJSONFile(File f) {
        JsonElement e = new JsonParser().parse((Reader)ReikaFileReader.getReader(f));
        if (e instanceof JsonObject) {
            JsonObject j = (JsonObject)e;
            for (Map.Entry entry : j.entrySet()) {
                JsonElement val = (JsonElement)entry.getValue();
                JsonArray arr = val.getAsJsonArray();
                for (JsonElement idx : arr) {
                    if (!(idx instanceof JsonObject)) continue;
                    JsonObject data = (JsonObject)idx;
                    String item = data.get("item").getAsString();
                    String dmg = data.get("damage").getAsString();
                    ItemStack stack = ReikaItemHelper.lookupItem(item + ":" + dmg);
                    this.allEntries.add(this.createKey(stack));
                }
            }
        }
    }
}

