/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.Auxiliary.Trackers.IDCollisionTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Exception.InstallationException;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.ItemBlockCustomLocalization;
import Reika.DragonAPI.Interfaces.Registry.BlockEnum;
import Reika.DragonAPI.Interfaces.Registry.EnchantmentEnum;
import Reika.DragonAPI.Interfaces.Registry.EntityEnum;
import Reika.DragonAPI.Interfaces.Registry.ItemEnum;
import Reika.DragonAPI.Interfaces.Registry.RegistryEntry;
import Reika.DragonAPI.Libraries.Java.ReikaReflectionHelper;
import Reika.DragonAPI.ModInteract.LegacyWailaHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.EnumHelper;

public final class ReikaRegistryHelper
extends DragonAPICore {
    private static final HashMap<BlockEnum, ArrayList<Integer>> blockVariants = new HashMap();
    private static final HashMap<ItemEnum, ArrayList<Integer>> itemVariants = new HashMap();
    private static final IdentityHashMap<Object, RegistryEntry> registries = new IdentityHashMap();
    private static final IdentityHashMap<Object, EntityCollection> modEntityRegistries = new IdentityHashMap();
    private static final HashMap<BlockEnum, String> blockRegNames = new HashMap();
    private static final HashMap<ItemEnum, String> itemRegNames = new HashMap();

    public static void instantiateAndRegisterBlocks(DragonAPIMod mod, BlockEnum[] enumr, Block[] target) {
        boolean canLoad;
        if (enumr.length != target.length) {
            throw new RegistrationException(mod, "Invalid storage array!");
        }
        boolean bl = canLoad = !Loader.instance().hasReachedState(LoaderState.INITIALIZATION);
        if (!canLoad) {
            throw new RegistrationException(mod, "This mod is loading blocks too late in the setup!");
        }
        for (int i = 0; i < enumr.length; ++i) {
            BlockEnum r = enumr[i];
            target[i] = ReikaRegistryHelper.registerBlock(mod, r, i);
        }
    }

    private static Block registerBlock(DragonAPIMod mod, BlockEnum r, int idx) {
        Block b = null;
        if (!r.isDummiedOut()) {
            b = ReikaReflectionHelper.createBlockInstance(mod, r);
            String regname = (mod.getTechnicalName() + "_block_" + r.name()).toLowerCase(Locale.ENGLISH);
            if (r.hasItemBlock()) {
                GameRegistry.registerBlock((Block)b, r.getItemBlock(), (String)regname);
            } else {
                GameRegistry.registerBlock((Block)b, ItemBlockCustomLocalization.class, (String)regname);
            }
            registries.put(b, r);
            registries.put(Item.func_150898_a((Block)b), r);
            blockRegNames.put(r, regname);
            int num = r.getNumberMetadatas();
            for (int k = 0; k < num; ++k) {
                ReikaRegistryHelper.registerBlockVariant(r, k);
            }
            if (r.hasItemBlock()) {
                mod.getModLogger().log("Instantiating Block " + r.getBasicName() + " with ID " + b + " to Block Variable " + b.getClass().getSimpleName() + " (enum index " + idx + ") with ItemBlock " + r.getItemBlock().getSimpleName());
            } else {
                mod.getModLogger().log("Instantiating Block " + r.getBasicName() + " with ID " + b + " to Block Variable " + b.getClass().getSimpleName() + " (enum index " + idx + ")");
            }
            if (ModList.WAILA.isLoaded() && InterfaceCache.WAILA.instanceOf(r.getObjectClass())) {
                LegacyWailaHelper.registerLegacyWAILACompat(r);
            }
        } else {
            mod.getModLogger().log("Not instantiating Item " + r.getBasicName() + ", as it is dummied out.");
        }
        return b;
    }

    public static void instantiateAndRegisterItems(DragonAPIMod mod, ItemEnum[] enumr, Item[] target) {
        boolean canLoad;
        if (enumr.length != target.length) {
            throw new RegistrationException(mod, "Invalid storage array!");
        }
        boolean bl = canLoad = !Loader.instance().hasReachedState(LoaderState.INITIALIZATION);
        if (!canLoad) {
            throw new RegistrationException(mod, "This mod is loading items too late in the setup!");
        }
        for (int i = 0; i < enumr.length; ++i) {
            ItemEnum r = enumr[i];
            target[i] = ReikaRegistryHelper.registerItem(mod, r, i);
        }
    }

    private static Item registerItem(DragonAPIMod mod, ItemEnum r, int idx) {
        Item it = null;
        if (!r.isDummiedOut()) {
            it = ReikaReflectionHelper.createItemInstance(mod, r);
            String regname = (mod.getTechnicalName() + "_item_" + r.name()).toLowerCase(Locale.ENGLISH);
            int num = r.getNumberMetadatas();
            for (int j = 0; j < num; ++j) {
                ReikaRegistryHelper.registerItemVariant(r, j);
            }
            GameRegistry.registerItem((Item)it, (String)regname);
            registries.put(it, r);
            itemRegNames.put(r, regname);
            mod.getModLogger().log("Instantiating Item " + r.getBasicName() + " with ID " + it + " to Item Variable " + it.getClass().getSimpleName() + " (enum index " + idx + "). Has " + r.getNumberMetadatas() + " metadatas.");
        } else {
            mod.getModLogger().log("Not instantiating Item " + r.getBasicName() + ", as it is dummied out.");
        }
        return it;
    }

    public static void instantiateAndRegisterEnchantments(DragonAPIMod mod, EnchantmentEnum[] enumr, Enchantment[] target) {
        boolean canLoad;
        if (enumr.length != target.length) {
            throw new RegistrationException(mod, "Invalid storage array!");
        }
        boolean bl = canLoad = !Loader.instance().hasReachedState(LoaderState.INITIALIZATION);
        if (!canLoad) {
            throw new RegistrationException(mod, "This mod is loading Enchantments too late in the setup!");
        }
        for (int i = 0; i < enumr.length; ++i) {
            EnchantmentEnum r = enumr[i];
            target[i] = ReikaRegistryHelper.registerEnchantment(mod, r, i);
        }
    }

    private static Enchantment registerEnchantment(DragonAPIMod mod, EnchantmentEnum r, int idx) {
        Enchantment it = null;
        if (!r.isDummiedOut()) {
            IDCollisionTracker.instance.addEnchantmentID(mod, r.getEnchantmentID(), r.getObjectClass());
            it = ReikaReflectionHelper.createEnchantmentInstance(mod, r.getObjectClass(), r.getEnchantmentID(), r.getUnlocalizedName(), false);
            String regname = (mod.getTechnicalName() + "_enchantment_" + r.name()).toLowerCase(Locale.ENGLISH);
            registries.put(it, r);
            mod.getModLogger().log("Instantiating Enchantment " + r.getBasicName() + " with ID " + it + " to Enchantment Variable " + it.getClass().getSimpleName() + " (enum index " + idx + ").");
        } else {
            mod.getModLogger().log("Not instantiating Enchantment " + r.getBasicName() + ", as it is dummied out.");
        }
        return it;
    }

    private static void registerBlockVariant(BlockEnum e, int meta) {
        ArrayList<Integer> li = blockVariants.get(e);
        if (li == null) {
            li = new ArrayList();
            blockVariants.put(e, li);
        }
        li.add(meta);
    }

    private static void registerItemVariant(ItemEnum e, int meta) {
        ArrayList<Integer> li = itemVariants.get(e);
        if (li == null) {
            li = new ArrayList();
            itemVariants.put(e, li);
        }
        li.add(meta);
    }

    public static int getNumberVariantsFor(BlockEnum b) {
        return blockVariants.containsKey(b) ? blockVariants.get(b).size() : 1;
    }

    public static int getNumberVariantsFor(ItemEnum e) {
        return itemVariants.containsKey(e) ? itemVariants.get(e).size() : 1;
    }

    public static ArrayList<Integer> getVariantsFor(BlockEnum b) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (blockVariants.containsKey(b)) {
            ArrayList<Integer> li = blockVariants.get(b);
            ret.addAll(li);
        }
        return ret;
    }

    public static ArrayList<Integer> getVariantsFor(ItemEnum e) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (itemVariants.containsKey(e)) {
            ArrayList<Integer> li = itemVariants.get(e);
            ret.addAll(li);
        }
        return ret;
    }

    public static void loadNames() {
        for (BlockEnum b : blockVariants.keySet()) {
            Item item = Item.func_150898_a((Block)b.getBlockInstance());
            if (!(item instanceof ItemBlockCustomLocalization)) continue;
            ((ItemBlockCustomLocalization)item).setEnumObject(b);
        }
    }

    public static LoaderState getForgeLoadState() {
        LoaderState[] list = LoaderState.values();
        for (int i = list.length - 1; i >= 0; --i) {
            if (!Loader.instance().hasReachedState(list[i])) continue;
            return list[i];
        }
        return list[0];
    }

    public static void setupModData(DragonAPIMod mod, FMLPreInitializationEvent evt) {
        String path;
        ModMetadata dat = evt.getModMetadata();
        dat.authorList.clear();
        dat.authorList.add(mod.getModAuthorName());
        dat.version = mod.getModVersion().toString();
        dat.credits = mod.getModAuthorName();
        dat.name = mod.getDisplayName();
        dat.url = mod.getDocumentationSite().toString();
        dat.updateUrl = mod.getUpdateCheckURL();
        if (dat.updateUrl == null) {
            dat.updateUrl = "";
        }
        dat.autogenerated = false;
        dat.logoFile = path = mod.getModAuthorName() + "/" + mod.getDisplayName() + "/logo.png";
    }

    public static boolean overrideBlock(DragonAPIMod mod, String blockField, Class<? extends Block> toOverride) {
        mod.getModLogger().log("Overriding Blocks." + blockField + " with " + toOverride);
        try {
            Field f = Blocks.class.getField(blockField);
            Block target = (Block)f.get(null);
            Constructor<? extends Block> c = toOverride.getConstructor(Material.class);
            Block block = c.newInstance(target.func_149688_o());
            block.func_149675_a(target.func_149653_t());
            block.func_149663_c(target.func_149739_a().substring(5));
            block.func_149713_g(target.func_149717_k());
            block.func_149715_a((float)block.func_149750_m());
            block.field_149765_K = target.field_149765_K;
            block.field_149782_v = target.field_149782_v;
            block.field_149781_w = target.field_149781_w;
            int id = Block.func_149682_b((Block)target);
            String name = Block.field_149771_c.func_148750_c((Object)target);
            Block.field_149771_c.func_148756_a(id, name, (Object)block);
            ReikaReflectionHelper.setFinalField(f, null, block);
            return true;
        }
        catch (Exception e) {
            mod.getModLogger().logError("Could not override Blocks." + blockField + " with " + toOverride);
            e.printStackTrace();
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static SoundCategory addSoundCategory(String name, String label) {
        SoundCategory cat = null;
        try {
            cat = (SoundCategory)EnumHelper.addEnum(SoundCategory.class, (String)name.toUpperCase(), (Class[])new Class[]{String.class, Integer.TYPE}, (Object[])new Object[]{label, SoundCategory.values().length});
            SoundCategory.field_147168_j.put(cat.func_147155_a(), cat);
            SoundCategory.field_147169_k.put(cat.func_147156_b(), cat);
            EnumMap map = (EnumMap)Minecraft.func_71410_x().field_71474_y.field_151446_aD;
            Minecraft.func_71410_x().field_71474_y.field_151446_aD = ReikaRegistryHelper.useSoundHashMap() ? new HashMap() : new EnumMap(SoundCategory.class);
            for (SoundCategory c : map.keySet()) {
                Minecraft.func_71410_x().field_71474_y.field_151446_aD.put(c, map.get(c));
            }
            Minecraft.func_71410_x().field_71474_y.field_151446_aD.put(cat, Float.valueOf(1.0f));
        }
        catch (Exception e) {
            if (e instanceof ArrayIndexOutOfBoundsException) {
                throw new InstallationException((DragonAPIMod)DragonAPIInit.instance, "Could not add sound category " + name + "! Use the Sound HashMap config!");
            }
            throw new RuntimeException("Could not add sound category " + name + "!", e);
        }
        return cat;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean useSoundHashMap() {
        return DragonOptions.SOUNDHASHMAP.getState();
    }

    public static RegistryEntry getRegistryForObject(Object o) {
        return registries.get(o);
    }

    public static String getGameRegistryName(DragonAPIMod mod, BlockEnum reg) {
        return mod.getModContainer().getModId() + ":" + blockRegNames.get(reg);
    }

    public static String getGameRegistryName(DragonAPIMod mod, ItemEnum reg) {
        return mod.getModContainer().getModId() + ":" + itemRegNames.get(reg);
    }

    public static void registerModEntity(Object mod, Class<? extends Entity> e, String name, boolean sendVelocity, int trackingDist) {
        boolean upd = sendVelocity;
        int dist = trackingDist;
        EntityCollection ec = ReikaRegistryHelper.getNextCollectionFor(mod);
        int id = ec.maxID;
        EntityRegistry.registerModEntity(e, (String)name, (int)id, (Object)mod, (int)dist, (int)(upd ? 20 : 1), (boolean)upd);
        ec.maxID++;
    }

    public static void registerModEntities(Object mod, EntityEnum[] list) {
        for (int i = 0; i < list.length; ++i) {
            EntityEnum e = list[i];
            if (e.isDummiedOut()) continue;
            boolean upd = e.sendsVelocityUpdates();
            int dist = e.getTrackingDistance();
            EntityCollection ec = ReikaRegistryHelper.getNextCollectionFor(mod);
            int id = ec.maxID;
            EntityRegistry.registerModEntity((Class)e.getObjectClass(), (String)e.getUnlocalizedName(), (int)id, (Object)mod, (int)dist, (int)(upd ? 20 : 1), (boolean)upd);
            if (e.hasSpawnEgg()) {
                // empty if block
            }
            ec.addEntry(e);
        }
    }

    public static List<EntityEnum> getEntityEnumForMod(Object mod) {
        EntityCollection ec = modEntityRegistries.get(mod);
        return ec != null ? Collections.unmodifiableList(ec.entities) : null;
    }

    private static EntityCollection getNextCollectionFor(Object mod) {
        EntityCollection ec = modEntityRegistries.get(mod);
        if (ec == null) {
            ec = new EntityCollection();
            modEntityRegistries.put(mod, ec);
        }
        return ec;
    }

    public static ArrayList<String> getMods() {
        ArrayList<String> ret = new ArrayList<String>();
        List li = Loader.instance().getActiveModList();
        for (ModContainer mc : li) {
            Object mod = mc.getMod();
            String name = mc.getModId();
            if (mod instanceof DragonAPIMod) {
                name = ((DragonAPIMod)mod).getDisplayName();
            } else {
                ModList en = ModList.getModFromID(mc.getModId());
                if (en != null) {
                    name = en.getDisplayName();
                }
            }
            String ver = mc.getDisplayVersion();
            if (mod instanceof DragonAPIMod) {
                ver = ((DragonAPIMod)mod).getModVersion().toString();
            }
            ret.add(name + ": " + ver);
        }
        return ret;
    }

    public static String getActiveLoadingMod() {
        ModContainer mc = Loader.instance().activeModContainer();
        return mc != null ? mc.getName() : "Null";
    }

    private static class EntityCollection {
        private int maxID = 1;
        private ArrayList<EntityEnum> entities = new ArrayList();

        private EntityCollection() {
        }

        private EntityCollection addEntry(EntityEnum e) {
            this.entities.add(e);
            ++this.maxID;
            return this;
        }
    }
}

