/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class ReikaIconHelper {
    public static IIcon clipFrom(IIcon tex, IIcon src, TextureMap map, String name) {
        try {
            return ReikaIconHelper.getDiff(tex, src, map, name, true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IIcon subtractFrom(IIcon sub, IIcon sum, TextureMap map, String name) {
        try {
            return ReikaIconHelper.getDiff(sub, sum, map, name, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IIcon getDiff(IIcon i1, IIcon i2, TextureMap map, String name, boolean clip) throws IOException {
        BufferedImage src = ReikaIconHelper.getIconImage(i2, map);
        BufferedImage tgt = ReikaIconHelper.getIconImage(i1, map);
        int w = src.getWidth();
        int h = src.getHeight();
        int type = src.getType();
        BufferedImage out = new BufferedImage(w, h, type);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int c2;
                boolean eq;
                int c1 = src.getRGB(x, y);
                boolean bl = eq = c1 == (c2 = tgt.getRGB(x, y));
                if (eq != clip) {
                    out.setRGB(x, y, c2);
                    continue;
                }
                out.setRGB(x, y, 0);
            }
        }
        return ReikaIconHelper.registerIcon(out, name, map);
    }

    private static IIcon registerIcon(BufferedImage out, String locName, TextureMap map) {
        IIcon ico = map.func_94245_a(locName);
        TextureAtlasSprite sp = (TextureAtlasSprite)ico;
        for (int i = 0; i < sp.func_110970_k(); ++i) {
            int[][] data = sp.func_147965_a(i);
            for (int x = 0; x < data.length; ++x) {
                for (int y = 0; y < data[x].length; ++y) {
                    int c = out.getRGB(x, y);
                    if (c == 0) continue;
                    data[x][y] = c;
                }
            }
        }
        return sp;
    }

    private static BufferedImage getIconImage(IIcon ico, TextureMap map) throws IOException {
        Map data = map.field_110574_e;
        for (String s : data.keySet()) {
            ResourceLocation loc = new ResourceLocation(s);
            TextureAtlasSprite spr = (TextureAtlasSprite)data.get(s);
            if (!spr.func_94215_i().equals(ico.func_94215_i())) continue;
            IResource ir = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
            return ImageIO.read(ir.func_110527_b());
        }
        throw new IOException("No image found!");
    }
}

