/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.ModList;
import net.minecraft.world.biome.BiomeGenBase;

public class ModSpawnEntry {
    private final ModClass mc;
    public final int weight;
    public final int minsize;
    public final int maxsize;

    public ModSpawnEntry(ModList mod, String c, int weight, int min, int max) {
        this.mc = new ModClass(mod, c);
        this.weight = weight;
        this.minsize = min;
        this.maxsize = max;
    }

    public boolean isLoadable() {
        return this.mc.mod.isLoaded();
    }

    public BiomeGenBase.SpawnListEntry getEntry() {
        if (!this.isLoadable()) {
            throw new MisuseException("You cannot load a spawn entry for a mod that is not loaded!");
        }
        try {
            BiomeGenBase.SpawnListEntry entry = new BiomeGenBase.SpawnListEntry(Class.forName(this.mc.className), this.weight, this.minsize, this.maxsize);
            return entry;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class ModClass {
        public final ModList mod;
        public final String className;

        public ModClass(ModList mod, String c) {
            this.mod = mod;
            this.className = c;
        }
    }
}

