/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class ControllableOreVein
extends WorldGenerator {
    private final BlockKey block;
    private final int veinSize;
    public Block target = Blocks.field_150348_b;

    public ControllableOreVein(Block block, int size) {
        this(new BlockKey(block), size);
    }

    public ControllableOreVein(Block block, int meta, int size) {
        this(new BlockKey(block, meta), size);
    }

    public ControllableOreVein(BlockKey b, int size) {
        this.block = b;
        this.veinSize = size;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        float f = rand.nextFloat() * (float)Math.PI;
        double xvar_pos = (float)(x + 8) + MathHelper.func_76126_a((float)f) * (float)this.veinSize / 8.0f;
        double xvar_neg = (float)(x + 8) - MathHelper.func_76126_a((float)f) * (float)this.veinSize / 8.0f;
        double zvar_pos = (float)(z + 8) + MathHelper.func_76134_b((float)f) * (float)this.veinSize / 8.0f;
        double zvar_neg = (float)(z + 8) - MathHelper.func_76134_b((float)f) * (float)this.veinSize / 8.0f;
        double ypos_1 = y + rand.nextInt(3) - 2;
        double ypos_2 = y + rand.nextInt(3) - 2;
        for (int l = 0; l <= this.veinSize; ++l) {
            double posx = xvar_pos + (xvar_neg - xvar_pos) * (double)l / (double)this.veinSize;
            double posy = ypos_1 + (ypos_2 - ypos_1) * (double)l / (double)this.veinSize;
            double posz = zvar_pos + (zvar_neg - zvar_pos) * (double)l / (double)this.veinSize;
            double range = rand.nextDouble() * (double)this.veinSize / 16.0;
            double range_horiz = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.veinSize)) + 1.0f) * range + 1.0;
            double range_vert = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.veinSize)) + 1.0f) * range + 1.0;
            int minx = MathHelper.func_76128_c((double)(posx - range_horiz / 2.0));
            int miny = MathHelper.func_76128_c((double)(posy - range_vert / 2.0));
            int minz = MathHelper.func_76128_c((double)(posz - range_horiz / 2.0));
            int maxx = MathHelper.func_76128_c((double)(posx + range_horiz / 2.0));
            int maxy = MathHelper.func_76128_c((double)(posy + range_vert / 2.0));
            int maxz = MathHelper.func_76128_c((double)(posz + range_horiz / 2.0));
            for (int dx = minx; dx <= maxx; ++dx) {
                double rx = ((double)dx + 0.5 - posx) / (range_horiz / 2.0);
                if (!(rx * rx < 1.0)) continue;
                for (int dy = miny; dy <= maxy; ++dy) {
                    double ry = ((double)dy + 0.5 - posy) / (range_vert / 2.0);
                    if (!(rx * rx + ry * ry < 1.0)) continue;
                    for (int dz = minz; dz <= maxz; ++dz) {
                        double rz = ((double)dz + 0.5 - posz) / (range_horiz / 2.0);
                        if (!(rx * rx + ry * ry + rz * rz < 1.0) || !world.func_147439_a(dx, dy, dz).isReplaceableOreGen(world, dx, dy, dz, this.target) || !this.canPlaceBlockHere(world, dx, dy, dz)) continue;
                        world.func_147465_d(dx, dy, dz, this.block.blockID, this.block.metadata, 2);
                    }
                }
            }
        }
        return true;
    }

    public abstract boolean canPlaceBlockHere(World var1, int var2, int var3, int var4);

    public static final class BlockExcludingOreVein
    extends ControllableOreVein {
        private final BlockCheck check;

        public BlockExcludingOreVein(Block block, int size, BlockCheck ch) {
            super(block, size);
            this.check = ch;
        }

        public BlockExcludingOreVein(Block block, int meta, int size, BlockCheck ch) {
            super(block, meta, size);
            this.check = ch;
        }

        public BlockExcludingOreVein(BlockKey block, int size, BlockCheck ch) {
            super(block, size);
            this.check = ch;
        }

        @Override
        public boolean canPlaceBlockHere(World world, int x, int y, int z) {
            return !this.check.matchInWorld(world, x, y, z);
        }
    }

    public static final class BlockAdjacentOreVein
    extends ControllableOreVein {
        private final BlockKey check;

        public BlockAdjacentOreVein(Block block, int size, BlockKey ch) {
            super(block, size);
            this.check = ch;
        }

        public BlockAdjacentOreVein(Block block, int meta, int size, BlockKey ch) {
            super(block, meta, size);
            this.check = ch;
        }

        public BlockAdjacentOreVein(BlockKey block, int size, BlockKey ch) {
            super(block, size);
            this.check = ch;
        }

        @Override
        public boolean canPlaceBlockHere(World world, int x, int y, int z) {
            return ReikaWorldHelper.checkForAdjBlock(world, x, y, z, this.check.blockID, this.check.metadata) != null;
        }
    }

    public static class ExposedOreVein
    extends ControllableOreVein {
        public ExposedOreVein(Block block, int size) {
            super(block, size);
        }

        public ExposedOreVein(Block block, int meta, int size) {
            super(block, meta, size);
        }

        public ExposedOreVein(BlockKey block, int size) {
            super(block, size);
        }

        @Override
        public boolean canPlaceBlockHere(World world, int x, int y, int z) {
            return ReikaWorldHelper.checkForAdjMaterial(world, x, y, z, Material.field_151579_a) != null;
        }
    }
}

