/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class TessellatorVertexList {
    private ArrayList<TessellatorVertex> data = new ArrayList();
    private final LinkedList<ArrayList<TessellatorVertex>> list = new LinkedList();
    public final double originX;
    public final double originY;
    public final double originZ;

    public TessellatorVertexList() {
        this(0.0, 0.0, 0.0);
    }

    public TessellatorVertexList(double x, double y, double z) {
        this.originX = x;
        this.originY = y;
        this.originZ = z;
    }

    public void addVertex(double x, double y, double z) {
        this.data.add(new TessellatorVertex(x, y, z));
    }

    public void addVertexWithUV(double x, double y, double z, double u, double v) {
        this.data.add(new TessellatorVertex(x, y, z, u, v));
    }

    public void addVertexWithUVColor(double x, double y, double z, double u, double v, int color) {
        this.data.add(new TessellatorVertex(x, y, z, u, v, color));
    }

    public void render() {
        for (TessellatorVertex v : this.data) {
            v.addToTessellator();
        }
    }

    public void reverse() {
        Collections.reverse(this.data);
    }

    public void offset(double dx, double dy, double dz) {
        for (TessellatorVertex v : this.data) {
            v.offset(dx, dy, dz);
        }
    }

    public void scale(double dx, double dy, double dz) {
        Iterator<TessellatorVertex> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TessellatorVertex v;
            TessellatorVertex tessellatorVertex = v = iterator.next();
            tessellatorVertex.posX = tessellatorVertex.posX * dx;
            tessellatorVertex = v;
            tessellatorVertex.posY = tessellatorVertex.posY * dy;
            tessellatorVertex = v;
            tessellatorVertex.posZ = tessellatorVertex.posZ * dz;
        }
    }

    public void clamp(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        for (TessellatorVertex v : this.data) {
            v.posX = MathHelper.func_151237_a((double)v.posX, (double)minx, (double)maxx);
            v.posY = MathHelper.func_151237_a((double)v.posY, (double)miny, (double)maxy);
            v.posZ = MathHelper.func_151237_a((double)v.posZ, (double)minz, (double)maxz);
        }
    }

    public void invertX() {
        for (TessellatorVertex v : this.data) {
            v.posX = 1.0 - v.posX;
        }
        this.reverse();
    }

    public void invertY() {
        for (TessellatorVertex v : this.data) {
            v.posY = 1.0 - v.posY;
        }
        this.reverse();
    }

    public void invertZ() {
        for (TessellatorVertex v : this.data) {
            v.posZ = 1.0 - v.posZ;
        }
        this.reverse();
    }

    public void rotateYtoZ() {
        for (TessellatorVertex v : this.data) {
            double z = v.posZ - this.originZ;
            v.posZ = this.originZ + v.posY - this.originY;
            v.posY = this.originY + z;
        }
        this.reverse();
    }

    public void rotateXtoZ() {
        for (TessellatorVertex v : this.data) {
            double z = v.posZ - this.originZ;
            v.posZ = this.originZ + v.posX - this.originX;
            v.posX = this.originX + z;
        }
        this.reverse();
    }

    public void rotateYtoX() {
        for (TessellatorVertex v : this.data) {
            double x = v.posX - this.originX;
            v.posX = this.originX + v.posY - this.originY;
            v.posY = this.originY + x;
        }
        this.reverse();
    }

    public void rotateNonOrthogonal(double rx, double ry, double rz) {
        this.rotateNonOrthogonal(rx, ry, rz, this.originX, this.originY, this.originZ);
    }

    public void rotateNonOrthogonal(double rx, double ry, double rz, double ox, double oy, double oz) {
        for (TessellatorVertex v : this.data) {
            v.rotate(rx, ry, rz, ox, oy, oz);
        }
    }

    public void center() {
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        for (TessellatorVertex v : this.data) {
            cx += v.posX;
            cy += v.posY;
            cz += v.posZ;
        }
        this.offset(-(cx /= (double)this.data.size()), -(cy /= (double)this.data.size()), -(cz /= (double)this.data.size()));
    }

    public void clear() {
        this.data.clear();
    }

    public void push() {
        this.list.addLast(this.data);
        this.data = new ArrayList();
    }

    public void pop() {
        if (this.list.isEmpty()) {
            throw new IllegalStateException("Popped an empty list!");
        }
        this.data = this.list.pollLast();
    }

    public void addAll(TessellatorVertexList li) {
        this.list.addAll(li.list);
        this.data.addAll(li.data);
    }

    public static class TessellatorVertex {
        private double posX;
        private double posY;
        private double posZ;
        private double posU;
        private double posV;
        private int colorData;
        private boolean hasUV;
        private boolean hasColor;

        public TessellatorVertex(double x, double y, double z) {
            this(x, y, z, 0.0, 0.0);
            this.hasUV = false;
        }

        public TessellatorVertex(double x, double y, double z, double u, double v) {
            this(x, y, z, u, v, 0);
            this.hasColor = false;
        }

        public TessellatorVertex(double x, double y, double z, double u, double v, int color) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.posU = u;
            this.posV = v;
            this.colorData = color;
            this.hasUV = true;
            this.hasColor = true;
        }

        public void addToTessellator() {
            if (this.hasColor) {
                Tessellator.field_78398_a.func_78378_d(this.colorData);
            }
            if (this.hasUV) {
                Tessellator.field_78398_a.func_78374_a(this.posX, this.posY, this.posZ, this.posU, this.posV);
            } else {
                Tessellator.field_78398_a.func_78377_a(this.posX, this.posY, this.posZ);
            }
        }

        public final boolean equals(Object o) {
            if (o instanceof TessellatorVertex) {
                TessellatorVertex v = (TessellatorVertex)o;
                if (v.posX == this.posX && v.posY == this.posY && v.posZ == this.posZ) {
                    return this.hasUV ? v.hasUV && v.posU == this.posU && v.posV == this.posV : !v.hasUV;
                }
            }
            return false;
        }

        public double x() {
            return this.posX;
        }

        public double y() {
            return this.posY;
        }

        public double z() {
            return this.posZ;
        }

        public TessellatorVertex copy() {
            if (this.hasColor) {
                return new TessellatorVertex(this.posX, this.posY, this.posZ, this.posU, this.posV, this.colorData);
            }
            return this.hasUV ? new TessellatorVertex(this.posX, this.posY, this.posZ, this.posU, this.posV) : new TessellatorVertex(this.posX, this.posY, this.posZ);
        }

        public void offset(double dx, double dy, double dz) {
            this.posX += dx;
            this.posY += dy;
            this.posZ += dz;
        }

        public void rotate(double rx, double ry, double rz, double ox, double oy, double oz) {
            Vec3 ret = ReikaVectorHelper.rotateVector(Vec3.func_72443_a((double)(this.posX - ox), (double)(this.posY - oy), (double)(this.posZ - oz)), rx, ry, rz);
            this.posX = ox + ret.field_72450_a;
            this.posY = oy + ret.field_72448_b;
            this.posZ = oz + ret.field_72449_c;
        }
    }
}

