/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import java.util.ArrayList;
import java.util.Random;

public class ColorBlendList {
    private final ArrayList<Integer> data = new ArrayList();
    private final float cycleModulus;

    public ColorBlendList(float speed) {
        this.cycleModulus = speed;
    }

    public ColorBlendList(float speed, int ... colors) {
        this(speed);
        this.addAll(colors);
    }

    public ColorBlendList addAll(int ... colors) {
        for (int i = 0; i < colors.length; ++i) {
            this.addColor(colors[i]);
        }
        return this;
    }

    public ColorBlendList addColor(int color) {
        this.data.add(color);
        return this;
    }

    public int getColor(double tick) {
        if (this.data.isEmpty()) {
            return 0;
        }
        long f1 = (long)(tick / (double)this.cycleModulus);
        f1 = (f1 + (long)this.data.size()) % (long)this.data.size();
        int c1 = this.data.get((int)f1 % this.data.size());
        int c2 = this.data.get(((int)f1 + 1) % this.data.size());
        float f = (float)(tick % (double)this.cycleModulus / (double)this.cycleModulus);
        return ReikaColorAPI.mixColors(c1, c2, 1.0f - f);
    }

    public ColorBlendList shiftHue(int dh) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int c : this.data) {
            int hue = ReikaColorAPI.getHue(c) + dh;
            li.add(ReikaColorAPI.getModifiedHue(c, hue));
        }
        this.data.clear();
        this.data.addAll(li);
        return this;
    }

    public ColorBlendList multiplySaturation(float fac) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int c : this.data) {
            li.add(ReikaColorAPI.getModifiedSat(c, fac));
        }
        this.data.clear();
        this.data.addAll(li);
        return this;
    }

    public ColorBlendList multiplyBrightness(float fac) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int c : this.data) {
            li.add(ReikaColorAPI.getColorWithBrightnessMultiplier(c, fac));
        }
        this.data.clear();
        this.data.addAll(li);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cycleModulus);
        sb.append("x [");
        for (int color : this.data) {
            sb.append(Integer.toHexString(color));
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public int getRandomBlendedColor(Random rand) {
        return this.getColor(rand.nextDouble() * (double)this.data.size() * (double)this.cycleModulus);
    }
}

