/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;

public class RandomVariance {
    public final double variance;
    public final double velocity;
    public final double tolerance;
    private double value;
    private double target;

    public RandomVariance(double var, double vel, double tol) {
        this.variance = var;
        this.velocity = vel;
        this.tolerance = tol;
    }

    public void update() {
        if (ReikaMathLibrary.approxr(this.value, this.target, this.tolerance)) {
            this.target = ReikaRandomHelper.getRandomPlusMinus(0.0, this.variance);
        }
        this.value += this.velocity * (this.target - this.value) / 16.0;
    }

    public double getValue() {
        return this.value;
    }
}

