/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public class ParallelTicker {
    private final HashMap<String, Integer> tickers = new HashMap();
    private final HashMap<String, Integer> caps = new HashMap();

    public void updateAll() {
        for (String key : this.tickers.keySet()) {
            this.updateTicker(key);
        }
    }

    public int getTickOf(String key) {
        if (!this.tickers.containsKey(key)) {
            return -1;
        }
        return this.tickers.get(key);
    }

    public int getCapOf(String key) {
        if (!this.caps.containsKey(key)) {
            return -1;
        }
        return this.caps.get(key);
    }

    public void updateTicker(String key) {
        if (this.tickers.containsKey(key)) {
            this.tickers.put(key, this.tickers.get(key) + 1);
        }
    }

    public ParallelTicker addTicker(String key) {
        this.tickers.put(key, 0);
        return this;
    }

    public ParallelTicker addTicker(String key, int cap) {
        this.addTicker(key);
        this.setCap(key, cap);
        return this;
    }

    public void setCap(String key, int cap) {
        if (this.tickers.containsKey(key)) {
            this.caps.put(key, cap);
        }
    }

    private boolean isAtCap(String key) {
        if (this.tickers.containsKey(key) && this.caps.containsKey(key)) {
            return this.tickers.get(key) >= this.caps.get(key);
        }
        return false;
    }

    public boolean checkCap(String key) {
        boolean cap = this.isAtCap(key);
        if (cap) {
            this.resetTicker(key);
        }
        return cap;
    }

    public void resetTicker(String key) {
        this.setTickOf(key, 0);
    }

    public void setTickOf(String key, int val) {
        if (this.tickers.containsKey(key)) {
            this.tickers.put(key, val);
        }
    }

    public float getPortionOfCap(String key) {
        if (this.tickers.containsKey(key) && this.caps.containsKey(key)) {
            if (this.caps.get(key) == 0) {
                return -1.0f;
            }
            return (float)this.tickers.get(key).intValue() / (float)this.caps.get(key).intValue();
        }
        return 0.0f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.tickers.keySet()) {
            String s = String.format("Timer %s: %d/%d (%.2f%s)", key, this.getTickOf(key), this.getCapOf(key), Float.valueOf(this.getPortionOfCap(key) * 100.0f), "%");
            sb.append(s + "\n");
        }
        return sb.toString();
    }

    public void writeToNBT(NBTTagCompound NBT, String id) {
        for (String ticker : this.tickers.keySet()) {
            String s = id + ticker;
            NBT.func_74768_a(s + "cap", this.getCapOf(ticker));
            NBT.func_74768_a(s + "tick", this.getTickOf(ticker));
        }
    }

    public void readFromNBT(NBTTagCompound NBT, String id) {
        for (String ticker : this.tickers.keySet()) {
            String s = id + ticker;
            this.setCap(ticker, NBT.func_74762_e(s + "cap"));
            this.setTickOf(ticker, NBT.func_74762_e(s + "tick"));
        }
    }
}

