/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.Ray;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;

public class Lattice {
    private final HashSet<Coordinate> originPoints = new HashSet();
    private final MultiMap<Coordinate, Ray> rays = new MultiMap(new MultiMap.HashSetFactory());
    private final BlockBox bounds;
    public int pointCount;
    public int rayCount;

    public Lattice(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.bounds = new BlockBox(x1, y1, z1, x2, y2, z2);
    }

    public Lattice addPoint(Coordinate c) {
        this.originPoints.add(c);
        return this;
    }

    public Lattice generatePoints(Random rand) {
        if (this.pointCount > this.bounds.getVolume()) {
            throw new IllegalArgumentException("Volume is too small for " + this.pointCount + " points!");
        }
        for (int i = 0; i < this.pointCount; ++i) {
            Coordinate c = this.bounds.getRandomContainedCoordinate(rand);
            while (this.originPoints.contains(c)) {
                c = this.bounds.getRandomContainedCoordinate(rand);
            }
            this.originPoints.add(c);
        }
        return this;
    }

    public Lattice generateRays(Random rand) {
        for (Coordinate c : this.originPoints) {
            for (int i = 0; i < this.rayCount; ++i) {
                Ray r = Ray.fromPolar(new DecimalPosition(c), rand.nextDouble() * 360.0, rand.nextDouble() * 360.0);
                this.rays.addValue(c, r);
            }
        }
        return this;
    }

    public Collection<Ray> getAllRays() {
        return Collections.unmodifiableCollection(this.rays.allValues(false));
    }

    public static class LatticeCache {
        private final HashSet<Coordinate> locations = new HashSet();

        public LatticeCache(Lattice c, int th) {
            for (Ray r : c.getAllRays()) {
                this.generateFromRay(c, r, th);
            }
        }

        private void generateFromRay(Lattice c, Ray r, int th) {
            Coordinate p;
            boolean flag = true;
            double d = 0.0;
            while (flag) {
                flag = false;
                p = r.getScaledPosition(d).getCoordinate();
                if (!c.bounds.isBlockInside(p)) continue;
                this.generateAt(p, th);
                d += 0.25;
                flag = true;
            }
            flag = true;
            d = 0.0;
            while (flag) {
                flag = false;
                p = r.getScaledPosition(d).getCoordinate();
                if (!c.bounds.isBlockInside(p)) continue;
                this.generateAt(p, th);
                d -= 0.25;
                flag = true;
            }
        }

        private void generateAt(Coordinate p, int th) {
            this.locations.add(p);
            if (--th == 1) {
                for (int i = 0; i < 6; ++i) {
                    this.locations.add(p.offset(ForgeDirection.VALID_DIRECTIONS[i], 1));
                }
            } else {
                for (int i = -(--th); i <= th; ++i) {
                    for (int j = -th; j <= th; ++j) {
                        for (int k = -th; k <= th; ++k) {
                            this.locations.add(p.offset(i, j, k));
                        }
                    }
                }
            }
        }

        public HashSet<Coordinate> getLocations() {
            return new HashSet<Coordinate>(this.locations);
        }
    }
}

