/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class LuaBlock {
    private static final Comparator<String> outputSorter = new OutputSorter();
    public final String name;
    private final LuaBlock parent;
    private final HashMap<String, LuaBlock> children = new HashMap();
    private final HashMap<String, String> data = new HashMap();
    private final LuaBlockDatabase tree;
    protected final HashSet<String> requiredElements = new HashSet();
    private boolean isListEntry = false;
    private boolean isList = false;

    protected LuaBlock(String n, LuaBlock lb, LuaBlockDatabase db) {
        if (n.equals("{")) {
            n = Integer.toHexString(System.identityHashCode(this));
            this.isListEntry = true;
        }
        this.name = n;
        this.parent = lb;
        LuaBlockDatabase luaBlockDatabase = this.tree = lb != null ? lb.tree : db;
        if (this.tree == null) {
            throw new MisuseException("You cannot create a LuaBlock without a containing tree!");
        }
        if (this.parent != null) {
            this.parent.children.put(this.name, this);
            this.parent.checkListType();
        }
        this.requiredElements.add("type");
    }

    private void checkListType() {
        if (!this.data.isEmpty()) {
            this.isList = false;
            return;
        }
        for (LuaBlock lb : this.children.values()) {
            if (lb.isListEntry()) continue;
            this.isList = false;
            return;
        }
        this.isList = true;
    }

    public final boolean isList() {
        return this.isList;
    }

    public final boolean isListEntry() {
        return this.isListEntry;
    }

    public final LuaBlock getParent() {
        return this.parent;
    }

    public final LuaBlock getTopParent() {
        LuaBlock lb = this;
        while (lb.parent != null) {
            lb = lb.parent;
        }
        return lb;
    }

    public final double getDouble(String key) {
        return this.containsKeyInherit(key) ? Double.parseDouble(this.getString(key)) : 0.0;
    }

    public final boolean getBoolean(String key) {
        return this.containsKey(key) ? Boolean.parseBoolean(this.getString(key)) : false;
    }

    public final int getInt(String key) {
        return this.containsKeyInherit(key) ? Integer.parseInt(this.getString(key)) : 0;
    }

    public final long getLong(String key) {
        return Long.parseLong(this.getString(key));
    }

    private boolean isString(String s) {
        return !Character.isDigit(s.charAt(s.charAt(0) == '-' && s.length() > 1 ? 1 : 0)) && !s.equalsIgnoreCase("true") && !s.equalsIgnoreCase("false");
    }

    public final String getString(String key) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        if (!this.canInherit(key)) {
            throw new IllegalArgumentException("Missing key '" + key + "' for '" + this.name + "'");
        }
        return this.inherit(key);
    }

    public final Collection<String> getKeys() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public final Collection<String> getDataValues() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    public final void putData(String key, String val) {
        this.data.put(key, val);
    }

    public final boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    public final boolean containsKeyInherit(String key) {
        if (this.data.containsKey(key)) {
            return true;
        }
        return !this.inherit(key).startsWith("[NULL");
    }

    public boolean hasChild(String s) {
        return this.children.containsKey(s);
    }

    public final Collection<LuaBlock> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    private String inherit(String key) {
        LuaBlock b = this;
        ArrayList<String> steps = new ArrayList<String>();
        LuaBlock orig = b;
        while (!b.data.containsKey("inherit") && b.parent != null) {
            steps.add(b.name);
            b = b.parent;
        }
        String inherit = b.data.get("inherit");
        if (inherit == null) {
            return "[NULL KEY INHERIT]";
        }
        LuaBlock lb = this.tree.getBlock(inherit);
        if (lb == null) {
            return "[NULL PARENT INHERIT]";
        }
        for (String s : steps) {
            if (lb.children.containsKey(s)) {
                lb = lb.children.get(s);
                continue;
            }
            throw new IllegalStateException("'" + orig.parent.name + "/" + orig.name + "' tried to inherit property '" + key + "', but could not.");
        }
        return lb.data.containsKey(key) ? lb.getString(key) : "[NULL DATA]";
    }

    private boolean canInherit(String key) {
        return !this.requiredElements.contains(key) && !key.equals("inherit");
    }

    public final LuaBlock getChild(String key) {
        return this.children.containsKey(key) ? this.children.get(key) : this.inheritChild(key);
    }

    private LuaBlock inheritChild(String key) {
        LuaBlock b = this;
        ArrayList<String> steps = new ArrayList<String>();
        while (!b.data.containsKey("inherit") && b.parent != null) {
            if (b != this) {
                steps.add(b.name);
            }
            b = b.parent;
        }
        String inherit = b.data.get("inherit");
        if (inherit == null) {
            return null;
        }
        LuaBlock lb = this.tree.getBlock(inherit);
        if (lb == null) {
            return null;
        }
        for (String s : steps) {
            lb = lb.children.get(s);
        }
        return lb.children.containsKey(key) ? lb.children.get(key) : null;
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(this.getIndent("----", indent) + "-------------" + this.name + "-------------\n");
        sb.append(this.getIndent("====", indent) + "=============DATA=============\n");
        for (String s : this.data.keySet()) {
            String val = this.data.get(s);
            sb.append(this.getIndent("\t", indent) + s + "=" + val);
            sb.append("\n");
        }
        if (!this.children.isEmpty()) {
            sb.append("\n");
            sb.append(this.getIndent("====", indent) + "=============CHILDREN=============\n");
            for (LuaBlock lb : this.children.values()) {
                sb.append(lb.toString(indent + 1));
            }
        }
        sb.append(this.getIndent("----", indent) + "---------------------------------------\n");
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    private String getIndent(String rpt, int idt) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < idt; ++i) {
            sb.append(rpt);
        }
        return sb.toString();
    }

    public final HashMap<String, Object> asHashMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String s : this.data.keySet()) {
            ret.put(s, this.parseObject(this.data.get(s)));
        }
        for (String s : this.children.keySet()) {
            LuaBlock b = this.children.get(s);
            ret.put(s, this.getObject(b));
        }
        return ret;
    }

    public final List<Object> asList() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (LuaBlock b : this.children.values()) {
            ret.add(this.getObject(b));
        }
        return ret;
    }

    private Object getObject(LuaBlock b) {
        return b.isListEntry() && b.data.size() == 1 && b.children.isEmpty() ? this.parseObject(b.data.values().iterator().next()) : (b.isList() ? b.asList() : b.asHashMap());
    }

    private Object parseObject(String s) {
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception exception2) {
                try {
                    return Double.parseDouble(s);
                }
                catch (Exception exception3) {
                    return s;
                }
            }
        }
    }

    public ArrayList<String> writeToStrings() {
        return this.writeToStrings(1);
    }

    private ArrayList<String> writeToStrings(int indent) {
        ArrayList<String> li = new ArrayList<String>();
        String pre = ReikaStringParser.getNOf("\t", indent);
        if (indent == 1) {
            li.add("{");
        }
        ArrayList<String> keys = new ArrayList<String>(this.data.keySet());
        Collections.sort(keys, outputSorter);
        for (String s : keys) {
            String val = this.data.get(s);
            if (this.isString(val)) {
                val = "\"" + val + "\"";
            }
            if (this.isList()) {
                li.add(pre + val);
                continue;
            }
            li.add(pre + s + " = " + val);
        }
        keys = new ArrayList<String>(this.children.keySet());
        Collections.sort(keys, outputSorter);
        for (String s : keys) {
            LuaBlock c = this.children.get(s);
            if (this.isList() || c.isListEntry() || s.equals("-")) {
                li.add(pre + "{");
            } else {
                li.add(pre + s + " = {");
            }
            li.addAll(c.writeToStrings(indent + 1));
            li.add(pre + "}");
        }
        if (indent == 1) {
            li.add("}");
        }
        return li;
    }

    private static class OutputSorter
    implements Comparator<String> {
        private OutputSorter() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals("type")) {
                return Integer.MIN_VALUE;
            }
            if (o2.equals("type")) {
                return Integer.MAX_VALUE;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }

    public static class LuaBlockDatabase {
        private LuaBlock block = new BasicLuaBlock("top", null, this);
        private final HashMap<String, LuaBlock> rawData = new HashMap();

        public final void loadFromFile(File f) {
            ArrayList<String> li = ReikaFileReader.getFileAsLines(f, false);
            ArrayList data = new ArrayList();
            int bracketLevel = 0;
            for (String s : li) {
                if ((s = this.cleanString(s)).isEmpty()) continue;
                if (s.contains("{")) {
                    ++bracketLevel;
                    if (s.endsWith(" = {")) {
                        s = s.substring(0, s.length() - 4);
                    }
                    this.block = new BasicLuaBlock(s, this.block, this);
                } else if (s.contains("}")) {
                    this.block = this.block.getParent();
                    --bracketLevel;
                }
                if (s.equals("{") || s.equals("}") || s.equals(this.block.name)) continue;
                String[] parts = (s = s.replaceAll("\"", "")).split("=");
                if (parts.length == 2) {
                    String s2;
                    String s1 = parts[0].substring(0, parts[0].length() - 1);
                    if (s1.charAt(s1.length() - 1) == ' ') {
                        s1 = s1.substring(1);
                    }
                    if ((s2 = parts[1]).charAt(0) == ' ') {
                        s2 = s2.substring(1);
                    }
                    this.block.putData(s1, s2);
                    continue;
                }
                this.block.putData(String.valueOf(this.block.data.size()), s);
            }
            if (bracketLevel != 0) {
                throw new IllegalArgumentException("Malformed file: bracket mismatch");
            }
        }

        private String cleanString(String s) {
            if (s.startsWith("//") || s.startsWith("--")) {
                return "";
            }
            if ((s = s.replaceAll("\t", "")).contains("--")) {
                s = s.substring(0, s.indexOf("--"));
            }
            if (s.contains("//")) {
                s = s.substring(0, s.indexOf("//"));
            }
            if (s.length() > 0) {
                while (!s.isEmpty() && s.charAt(s.length() - 1) == ' ') {
                    s = s.substring(0, s.length() - 1);
                }
                while (!s.isEmpty() && s.charAt(0) == ' ') {
                    s = s.substring(1, s.length());
                }
            }
            return s;
        }

        public void addBlock(String key, LuaBlock b) {
            this.rawData.put(key, b);
        }

        public void clear() {
            this.rawData.clear();
        }

        public LuaBlock getBlock(String key) {
            return this.rawData.get(key);
        }

        public LuaBlock getRootBlock() {
            return this.block.getTopParent();
        }
    }

    private static class BasicLuaBlock
    extends LuaBlock {
        protected BasicLuaBlock(String n, LuaBlock lb, LuaBlockDatabase db) {
            super(n, lb, db);
        }
    }
}

