/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigReader {
    private String modName;
    private String filepath;
    private static final String ext = ".cfg";
    private Configuration config;
    private File configFile;

    public ConfigReader(String mod) {
        this(mod, mod + ext);
    }

    public ConfigReader(String mod, String file) {
        this.modName = mod;
        this.filepath = "?" + file;
        this.setFile();
    }

    private void setFile() {
        this.configFile = new File(this.filepath);
        if (!this.configFile.exists()) {
            DragonAPICore.logError("Config for " + this.modName + " does not exist at " + this.filepath + "!\nThis reader is only designed for force-reading of existing data!");
            return;
        }
        this.config = new Configuration(this.configFile);
    }

    public int getConfigInt(String cat, String key) {
        if (!this.config.hasKey(cat, key)) {
            throw new MisuseException("Config for " + this.modName + " at " + this.filepath + " does not contain category " + cat + " and key " + key + "\nThis reader is only designed for force-reading of existing data!");
        }
        return this.config.get(cat, key, 0).getInt();
    }

    public boolean getConfigBoolean(String cat, String key) {
        if (!this.config.hasKey(cat, key)) {
            throw new MisuseException("Config for " + this.modName + " at " + this.filepath + " does not contain category " + cat + " and key " + key + "\nThis reader is only designed for force-reading of existing data!");
        }
        return this.config.get(cat, key, false).getBoolean(false);
    }
}

