/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.TimerMap;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public final class ScheduledTickEvent
extends Event
implements TimerMap.FreezableTimer {
    private final ScheduledEvent action;

    public ScheduledTickEvent(ScheduledEvent evt) {
        this.action = evt;
    }

    public final void fire() {
        MinecraftForge.EVENT_BUS.post((Event)this);
        this.action.fire();
    }

    public final boolean runOnSide(Side s) {
        return this.action.runOnSide(s);
    }

    @Override
    public final boolean isFrozen() {
        return this.action instanceof DelayableSchedulableEvent && !((DelayableSchedulableEvent)this.action).canTick();
    }

    @Override
    public void call() {
        if (this.action.runOnSide(FMLCommonHandler.instance().getEffectiveSide())) {
            this.fire();
        }
    }

    public static interface DelayableSchedulableEvent
    extends ScheduledEvent {
        public boolean canTick();
    }

    public static interface ScheduledEvent {
        public void fire();

        public boolean runOnSide(Side var1);
    }

    public static final class ScheduledPacket
    implements ScheduledEvent {
        public final String channel;
        public final int packetID;
        public final int radius;
        private final World world;
        private final int xCoord;
        private final int yCoord;
        private final int zCoord;
        private final int[] data;

        public ScheduledPacket(String ch, int id, World world, int x, int y, int z, int r, int ... data) {
            this.channel = ch;
            this.packetID = id;
            this.radius = r;
            this.world = world;
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.data = data;
        }

        @Override
        public void fire() {
            ReikaPacketHelper.sendDataPacketWithRadius(this.channel, this.packetID, this.world, this.xCoord, this.yCoord, this.zCoord, this.radius, this.data);
        }

        @Override
        public boolean runOnSide(Side s) {
            return s == Side.SERVER;
        }
    }

    public static class ScheduledBlockBreak
    implements ScheduledEvent {
        private final WorldLocation location;

        public ScheduledBlockBreak(WorldLocation loc) {
            this.location = loc;
        }

        @Override
        public void fire() {
            ReikaWorldHelper.dropAndDestroyBlockAt(this.location.getWorld(), this.location.xCoord, this.location.yCoord, this.location.zCoord, null, true, true);
        }

        @Override
        public boolean runOnSide(Side s) {
            return s == Side.SERVER;
        }
    }

    public static class ScheduledBlockPlace
    implements ScheduledEvent {
        private final BlockKey block;
        private final WorldLocation location;

        public ScheduledBlockPlace(World world, int x, int y, int z, Block b) {
            this(world, x, y, z, b, 0);
        }

        public ScheduledBlockPlace(World world, int x, int y, int z, Block b, int meta) {
            this.block = new BlockKey(b, meta);
            this.location = new WorldLocation(world, x, y, z);
        }

        @Override
        public void fire() {
            this.location.setBlock(this.block.blockID, this.block.metadata);
            World world = this.location.getWorld();
            int x = this.location.xCoord;
            int y = this.location.yCoord;
            int z = this.location.zCoord;
            ReikaPacketHelper.sendDataPacketWithRadius("DragonAPIData", APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), world, x, y, z, 128, Block.func_149682_b((Block)this.block.blockID), this.block.metadata);
            ReikaSoundHelper.playBreakSound(world, x, y, z, this.block.blockID);
        }

        @Override
        public boolean runOnSide(Side s) {
            return s == Side.SERVER;
        }
    }

    public static class DelayedAttack
    implements ScheduledEvent {
        private final EntityLivingBase target;
        private final DamageSource source;
        private final float amount;

        public DelayedAttack(EntityLivingBase e, DamageSource src, float amt) {
            this.target = e;
            this.source = src;
            this.amount = amt;
        }

        @Override
        public void fire() {
            this.target.func_70097_a(this.source, this.amount);
        }

        @Override
        public boolean runOnSide(Side s) {
            return s == Side.SERVER;
        }
    }

    public static class ScheduledSoundEventClient
    implements ScheduledEvent {
        private final SoundEnum sound;
        private final float volume;
        private final float pitch;
        private World world;
        private double posX;
        private double posY;
        private double posZ;
        private Entity entity;
        public boolean attenuate = true;

        private ScheduledSoundEventClient(SoundEnum s, float v, float p) {
            this.sound = s;
            this.volume = v;
            this.pitch = p;
        }

        public ScheduledSoundEventClient(SoundEnum s, Entity e, float v, float p) {
            this(s, v, p);
            this.entity = e;
        }

        public ScheduledSoundEventClient(SoundEnum s, World w, double x, double y, double z, float v, float p) {
            this(s, v, p);
            this.world = w;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }

        @Override
        public void fire() {
            ReikaSoundHelper.playClientSound(this.sound, this.getX(), this.getY(), this.getZ(), this.volume, this.pitch, this.attenuate);
        }

        protected Entity getEntity() {
            return this.entity;
        }

        private double getX() {
            return this.entity != null ? this.entity.field_70165_t : this.posX;
        }

        private double getY() {
            return this.entity != null ? this.entity.field_70163_u : this.posY;
        }

        private double getZ() {
            return this.entity != null ? this.entity.field_70161_v : this.posZ;
        }

        @Override
        public boolean runOnSide(Side s) {
            return s == Side.CLIENT;
        }
    }

    public static class ScheduledSoundEvent
    implements ScheduledEvent {
        private final SoundEnum sound;
        private final float volume;
        private final float pitch;
        private World world;
        private double posX;
        private double posY;
        private double posZ;
        private Entity entity;
        public boolean attenuate = true;
        public int broadcastRange = 64;

        private ScheduledSoundEvent(SoundEnum s, float v, float p) {
            this.sound = s;
            this.volume = v;
            this.pitch = p;
        }

        public ScheduledSoundEvent(SoundEnum s, Entity e, float v, float p) {
            this(s, v, p);
            this.entity = e;
        }

        public ScheduledSoundEvent(SoundEnum s, World w, double x, double y, double z, float v, float p) {
            this(s, v, p);
            this.world = w;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }

        @Override
        public void fire() {
            if (this.attenuate) {
                this.sound.playSound(this.getWorld(), this.getX(), this.getY(), this.getZ(), this.volume, this.pitch, true);
            } else {
                this.sound.playSoundNoAttenuation(this.getWorld(), this.getX(), this.getY(), this.getZ(), this.volume, this.pitch, this.broadcastRange);
            }
        }

        protected Entity getEntity() {
            return this.entity;
        }

        private World getWorld() {
            return this.entity != null ? this.entity.field_70170_p : this.world;
        }

        private double getX() {
            return this.entity != null ? this.entity.field_70165_t : this.posX;
        }

        private double getY() {
            return this.entity != null ? this.entity.field_70163_u : this.posY;
        }

        private double getZ() {
            return this.entity != null ? this.entity.field_70161_v : this.posZ;
        }

        @Override
        public boolean runOnSide(Side s) {
            return s == Side.SERVER;
        }
    }
}

