/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Effects;

import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AnimatedTexture {
    public final String texturePath;
    public final Class referenceClass;
    public final int numberFrames;
    public final int frameDelay;
    public final int xSize;
    public final int ySize;
    private static final Tessellator v5 = Tessellator.field_78398_a;

    public AnimatedTexture(Class ref, String path, int x, int y, int size, int delay) {
        this.referenceClass = ref;
        this.texturePath = path;
        this.numberFrames = size;
        this.frameDelay = delay;
        this.xSize = x;
        this.ySize = y;
    }

    public void render() {
        ReikaTextureHelper.bindTexture(this.referenceClass, this.texturePath);
        int frame = this.getCurrentFrame();
        float u = (float)frame / (float)this.numberFrames;
        float du = u + (float)this.xSize / (float)this.numberFrames;
        GL11.glEnable((int)3042);
        v5.func_78382_b();
        v5.func_78376_a(255, 255, 255);
        v5.func_78374_a(0.0, 0.0, 0.0, (double)u, 0.0);
        v5.func_78374_a(1.0, 0.0, 0.0, (double)du, 0.0);
        v5.func_78374_a(1.0, 1.0, 0.0, (double)du, 1.0);
        v5.func_78374_a(0.0, 1.0, 0.0, (double)u, 1.0);
        v5.func_78381_a();
    }

    public int getCurrentFrame() {
        long time = System.currentTimeMillis();
        int per = (int)(time / (long)this.frameDelay);
        return per % this.numberFrames;
    }
}

