/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public final class MultiMap<K, V> {
    private final Map<K, Collection<V>> data;
    private boolean modifiable = true;
    private boolean nullEmpty = false;
    private Comparator<V> ordering = null;
    private final CollectionFactory factory;

    public MultiMap() {
        this(null);
    }

    public MultiMap(CollectionFactory cf) {
        this(cf, null);
    }

    public MultiMap(CollectionFactory cf, MapDeterminator md) {
        this.factory = cf != null ? cf : new ListFactory();
        this.data = md != null ? md.getMapType() : new HashMap<K, Collection<Collection<V>>>();
    }

    public Collection<V> put(K key, Collection<V> value) {
        Collection old;
        if (!this.modifiable) {
            throw new UnsupportedOperationException("Map " + this + " is locked!");
        }
        if (this.ordering != null && value instanceof List) {
            Collections.sort((List)value, this.ordering);
        }
        if ((old = this.data.put(key, this.factory.createCollection(value))) != null) {
            this.removeContainKeys(key, old);
        }
        this.addContainKeys(key, value);
        return old;
    }

    private void removeContainKey(K key, V value) {
    }

    private void removeContainKeys(K key, Collection<V> set) {
    }

    private void addContainKey(K key, V value) {
    }

    private void addContainKeys(K key, Collection<V> set) {
    }

    public Collection<V> putValue(K key, V value) {
        Collection<V> ret = this.remove(key);
        if (ret != null) {
            this.removeContainKeys(key, ret);
        }
        this.addValue(key, value, false, false);
        return ret;
    }

    public boolean addValue(K key, V value) {
        return this.addValue(key, value, false);
    }

    public boolean addValue(K key, V value, boolean allowCopies) {
        return this.addValue(key, value, true, allowCopies);
    }

    private boolean addValue(K key, V value, boolean load, boolean copy) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("Map " + this + " is locked!");
        }
        Collection<V> li = null;
        if (load) {
            li = this.data.get(key);
        }
        if (!load || li == null) {
            li = this.createCollection();
            this.data.put(key, li);
        }
        if (copy || !this.factory.allowsDuplicates() || !this.containsValueForKey(key, value)) {
            boolean ret = li.add(value);
            if (this.ordering != null && li instanceof List) {
                Collections.sort((List)li, this.ordering);
            }
            this.addContainKey(key, value);
            return ret;
        }
        return false;
    }

    public void sort(Comparator<V> sorter) {
        for (Collection<V> c : this.data.values()) {
            if (!(c instanceof List)) continue;
            Collections.sort((List)c, sorter);
        }
    }

    private Collection<V> createCollection() {
        return this.factory.createCollection();
    }

    public Collection<V> remove(K key) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("Map " + this + " is locked!");
        }
        ArrayList ret = this.data.remove(key);
        if (ret != null) {
            this.removeContainKeys(key, ret);
        }
        return ret != null ? ret : new ArrayList();
    }

    public Collection<V> get(K key) {
        Collection<V> c = this.data.get(key);
        if (c == null && this.nullEmpty) {
            return null;
        }
        return c != null ? (this.modifiable ? c : Collections.unmodifiableCollection(c)) : this.factory.createCollection();
    }

    public boolean containsKey(K key) {
        return this.data.containsKey(key);
    }

    public int getSize() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void clear() {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("Map " + this + " is locked!");
        }
        this.data.clear();
    }

    public Collection<K> keySet() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public Collection<Collection<V>> values() {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("Map " + this + " is locked!");
        }
        return Collections.unmodifiableCollection(this.data.values());
    }

    public Collection<V> allValues(boolean duplicates) {
        AbstractCollection li = duplicates ? new ArrayList() : new HashSet();
        for (Collection<V> c : this.data.values()) {
            li.addAll(c);
        }
        return li;
    }

    public void shuffleValues() {
        for (Collection<V> c : this.data.values()) {
            if (!(c instanceof List)) continue;
            Collections.shuffle((List)c);
        }
    }

    public int totalSize() {
        int s = 0;
        for (Collection<V> c : this.data.values()) {
            s += c.size();
        }
        return s;
    }

    public boolean containsValue(V value) {
        return ReikaJavaLibrary.collectionMapContainsValue(this.data, value);
    }

    public boolean containsValueForKey(K key, V value) {
        Collection<V> c = this.data.get(key);
        return c != null && c.contains(value);
    }

    public boolean remove(K key, V value) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("Map " + this + " is locked!");
        }
        Collection<V> c = this.data.get(key);
        boolean flag = c != null && c.remove(value);
        this.removeContainKey(key, value);
        if (flag && c.isEmpty()) {
            this.data.remove(key);
        }
        return flag;
    }

    public String toString() {
        return this.data.toString();
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof MultiMap && this.data.equals(((MultiMap)o).data);
    }

    public MultiMap<K, V> lock() {
        this.modifiable = false;
        return this;
    }

    public MultiMap<K, V> setNullEmpty() {
        this.nullEmpty = true;
        return this;
    }

    public MultiMap<K, V> setOrdered(Comparator<V> order) {
        this.ordering = order;
        return this;
    }

    public void putAll(Map<K, V> map) {
        for (K k : map.keySet()) {
            this.addValue(k, map.get(k));
        }
    }

    public void putAll(MultiMap<K, V> map) {
        for (K k : map.keySet()) {
            for (V v : map.get(k)) {
                this.addValue(k, v);
            }
        }
    }

    public static final class SortedDeterminator
    implements MapDeterminator {
        private final Comparator sorter;

        public SortedDeterminator() {
            this(null);
        }

        public SortedDeterminator(Comparator c) {
            this.sorter = c;
        }

        public Map getMapType() {
            return new TreeMap(this.sorter);
        }
    }

    public static final class ConcurrencyDeterminator
    implements MapDeterminator {
        public Map getMapType() {
            return new ConcurrentHashMap();
        }
    }

    public static final class ConcurrentHashSetFactory
    implements CollectionFactory<Set> {
        public Set createCollection() {
            return Collections.newSetFromMap(new ConcurrentHashMap());
        }

        public Set createCollection(Collection c) {
            Set s = Collections.newSetFromMap(new ConcurrentHashMap());
            s.addAll(c);
            return s;
        }

        @Override
        public boolean allowsDuplicates() {
            return false;
        }
    }

    public static final class HashSetFactory
    implements CollectionFactory<HashSet> {
        public HashSet createCollection() {
            return new HashSet();
        }

        public HashSet createCollection(Collection c) {
            return new HashSet(c);
        }

        @Override
        public boolean allowsDuplicates() {
            return false;
        }
    }

    public static final class ListFactory
    implements CollectionFactory<ArrayList> {
        public ArrayList createCollection() {
            return new ArrayList();
        }

        public ArrayList createCollection(Collection c) {
            return new ArrayList(c);
        }

        @Override
        public boolean allowsDuplicates() {
            return true;
        }
    }

    public static interface MapDeterminator<K, V> {
        public Map<? extends K, ? extends V> getMapType();
    }

    public static interface CollectionFactory<C> {
        public Collection<? extends C> createCollection();

        public Collection<? extends C> createCollection(Collection var1);

        public boolean allowsDuplicates();
    }
}

