/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;

public final class MixMap<V, K> {
    private final HashMap<V, HashMap<V, K>> data = new HashMap();
    private final HashMap<K, ArrayList<ImmutablePair<V, V>>> reverse = new HashMap();

    public void addSelfMix(V key, K mix) {
        this.addOrSetKey(key, key, mix);
    }

    public void addMix(V v1, V v2, K mix) {
        this.addOrSetKey(v1, v2, mix);
    }

    private void addOrSetKey(V v1, V v2, K mix) {
        HashMap<K, V> map = this.data.get(v1);
        if (map == null) {
            map = new HashMap();
            this.data.put((HashMap<Object, Object>)v1, (HashMap<HashMap<Object, Object>, V>)map);
        }
        map.put(v2, mix);
        map = this.data.get(v2);
        if (map == null) {
            map = new HashMap();
            this.data.put((HashMap<K, V>)v2, (HashMap<HashMap<K, V>, V>)map);
        }
        map.put(v1, mix);
        this.addReverseMapping(v1, v2, mix);
    }

    private void addReverseMapping(V v1, V v2, K mix) {
        ArrayList<Object> li = this.reverse.get(mix);
        if (li == null) {
            li = new ArrayList();
            this.reverse.put(mix, li);
        }
        li.add(new ImmutablePair(v1, v2));
    }

    public K getMix(V v1, V v2) {
        HashMap<V, K> map = this.data.get(v1);
        return map != null ? (K)map.get(v2) : null;
    }

    public Collection<V> getMixablesWith(V v1) {
        Map map = this.data.get(v1);
        return map != null ? Collections.unmodifiableCollection(map.keySet()) : null;
    }

    public Collection<K> getChildrenOf(V v1) {
        Map map = this.data.get(v1);
        return map != null ? Collections.unmodifiableCollection(map.values()) : null;
    }

    public Collection<V> getMixParents(K k) {
        HashSet<Object> c = new HashSet<Object>();
        Collection<ImmutablePair<V, V>> pairs = this.getMixesMaking(k);
        if (pairs != null) {
            for (ImmutablePair<V, V> p : pairs) {
                c.add(p.left);
                c.add(p.right);
            }
        }
        return c;
    }

    public boolean containsKey(V obj) {
        return this.data.containsKey(obj);
    }

    public Collection<ImmutablePair<V, V>> getMixesMaking(K mix) {
        ArrayList<Object> li = this.reverse.get(mix);
        if (li == null) {
            li = new ArrayList();
        }
        return Collections.unmodifiableCollection(li);
    }

    public V getOtherEntry(K mix, V entry) {
        ArrayList<ImmutablePair<V, V>> li = this.reverse.get(mix);
        if (li == null) {
            return null;
        }
        for (ImmutablePair<V, V> key : li) {
            if (key.left.equals(entry)) {
                return (V)key.right;
            }
            if (!key.right.equals(entry)) continue;
            return (V)key.left;
        }
        return null;
    }
}

