/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class BlockVector {
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;
    public final ForgeDirection direction;

    public BlockVector(ForgeDirection dir, Coordinate c) {
        this(dir, c.xCoord, c.yCoord, c.zCoord);
    }

    public BlockVector(ForgeDirection dir, TileEntity c) {
        this(dir, c.field_145851_c, c.field_145848_d, c.field_145849_e);
    }

    public BlockVector(ForgeDirection dir, WorldLocation c) {
        this(dir, c.xCoord, c.yCoord, c.zCoord);
    }

    public BlockVector(ForgeDirection dir, int x, int y, int z) {
        this(x, y, z, dir);
    }

    public BlockVector(int x, int y, int z, ForgeDirection dir) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.direction = dir;
    }

    public String toString() {
        return this.xCoord + ", " + this.yCoord + ", " + this.zCoord + " > " + this.direction;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("x", this.xCoord);
        tag.func_74768_a("y", this.yCoord);
        tag.func_74768_a("z", this.zCoord);
        tag.func_74768_a("dir", this.direction.ordinal());
    }

    public static BlockVector readFromNBT(NBTTagCompound tag) {
        int x = tag.func_74762_e("x");
        int y = tag.func_74762_e("y");
        int z = tag.func_74762_e("z");
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[tag.func_74762_e("dir")];
        return new BlockVector(x, y, z, dir);
    }
}

