/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.IO.NBTFile;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StructureExport
extends NBTFile {
    private final HashMap<Coordinate, BlockData> data = new HashMap();
    private final HashSet<String> watchedNBT = new HashSet();
    private final HashMap<String, Object> extraNBT = new HashMap();
    private final HashMap<String, NBTCallback> overrides = new HashMap();
    private final HashSet<BlockKey> ignoreSet = new HashSet();
    private BlockBox bounds = BlockBox.nothing();
    public PlacementCallback placeCallback;

    public StructureExport(String name) {
        this(name, "", null);
    }

    public StructureExport(String name, String path, Class c) {
        super(name, c != null ? path + "/" + name + ".struct" : DragonAPICore.getMinecraftDirectoryString() + "/StructureData/" + path + "/" + name + ".struct", c);
    }

    public StructureExport addWatchedNBT(String tag) {
        this.watchedNBT.add(tag);
        return this;
    }

    public StructureExport addWatchedNBT(Collection<String> c) {
        for (String s : c) {
            this.addWatchedNBT(s);
        }
        return this;
    }

    public StructureExport addIgnoredBlock(BlockKey bk) {
        this.ignoreSet.add(bk);
        return this;
    }

    public void setExtraNBTTag(String s, Object val) {
        NBTBase b = ReikaNBTHelper.getTagForObject(val);
        if (b != null) {
            this.extraNBT.put(s, val);
            for (BlockData dat : this.data.values()) {
                if (!dat.hasTileEntity) continue;
                dat.tileData.func_74782_a(s, b);
            }
        }
    }

    public void addNBTOverride(String s, NBTCallback call) {
        this.overrides.put(s, call);
        for (BlockData dat : this.data.values()) {
            NBTBase tag;
            if (!dat.hasTileEntity || dat.tileData == null || (tag = dat.tileData.func_74781_a(s)) == null) continue;
            dat.tileData.func_74782_a(s, call.getOverriddenValue(dat.position, dat.block, s, tag.func_74737_b(), (NBTTagCompound)dat.tileData.func_74737_b()));
        }
    }

    public void addRegion(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    this.addCoordinate(world, x, y, z);
                }
            }
        }
    }

    public void addCoordinate(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z)) {
            return;
        }
        if (this.ignoreSet.contains(BlockKey.getAt((IBlockAccess)world, x, y, z))) {
            return;
        }
        BlockData dat = new BlockData(world, x, y, z, this.watchedNBT, this.extraNBT, this.overrides);
        this.data.put(dat.position, dat);
        this.calcBounds();
    }

    private void calcBounds() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Coordinate c : this.data.keySet()) {
            minX = Math.min(minX, c.xCoord);
            minY = Math.min(minY, c.yCoord);
            minZ = Math.min(minZ, c.zCoord);
            maxX = Math.max(maxX, c.xCoord);
            maxY = Math.max(maxY, c.yCoord);
            maxZ = Math.max(maxZ, c.zCoord);
        }
        this.bounds = new BlockBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public BlockBox getBounds() {
        return this.bounds;
    }

    public void place(World world) {
        for (BlockData dat : this.data.values()) {
            dat.place(world);
            if (this.placeCallback == null) continue;
            this.placeCallback.onPlace(dat.position, dat.block, dat.tileData != null ? (NBTTagCompound)dat.tileData.func_74737_b() : null);
        }
    }

    public void place(ChunkSplicedGenerationCache world) {
        for (BlockData dat : this.data.values()) {
            dat.place(world);
            if (this.placeCallback == null) continue;
            this.placeCallback.onPlace(dat.position, dat.block, dat.tileData != null ? (NBTTagCompound)dat.tileData.func_74737_b() : null);
        }
    }

    public void offset(Coordinate offset) {
        HashMap<Coordinate, BlockData> next = new HashMap<Coordinate, BlockData>();
        for (Coordinate c : this.data.keySet()) {
            BlockData b = this.data.get(c);
            next.put(c.offset(offset), b.offset(offset));
        }
        this.data.clear();
        this.data.putAll(next);
        this.bounds = this.bounds.offset(offset);
    }

    @Override
    protected void readHeader(NBTTagCompound header) {
        NBTTagList li = header.func_150295_c("tags", ReikaNBTHelper.NBTTypes.STRING.ID);
        for (Object o : li.field_74747_a) {
            NBTTagString s = (NBTTagString)o;
            this.watchedNBT.add(s.func_150285_a_());
        }
    }

    @Override
    protected void readData(NBTTagList li) {
        for (Object o : li.field_74747_a) {
            NBTTagCompound dat = (NBTTagCompound)o;
            BlockData b = BlockData.readFromNBT(dat, this.watchedNBT, this.extraNBT);
            if (b == null || this.ignoreSet.contains(b.block)) continue;
            this.data.put(b.position, b);
        }
        this.calcBounds();
    }

    @Override
    protected void readExtraData(NBTTagCompound extra) {
        this.extraNBT.clear();
        this.extraNBT.putAll((Map)ReikaNBTHelper.getValue((NBTBase)extra));
    }

    @Override
    protected void writeHeader(NBTTagCompound header) {
        NBTTagList li = new NBTTagList();
        for (String s : this.watchedNBT) {
            li.func_74742_a((NBTBase)new NBTTagString(s));
        }
        header.func_74782_a("tags", (NBTBase)li);
    }

    @Override
    protected void writeData(NBTTagList li) {
        for (BlockData b : this.data.values()) {
            NBTTagCompound tag = b.writeToNBT();
            li.func_74742_a((NBTBase)tag);
        }
    }

    @Override
    protected NBTTagCompound writeExtraData() {
        return (NBTTagCompound)ReikaNBTHelper.getTagForObject(this.extraNBT);
    }

    public StructureExport copy() {
        StructureExport cp = new StructureExport(this.name + "_copy");
        cp.encryptData = this.encryptData;
        cp.compressData = this.compressData;
        cp.data.putAll(this.data);
        cp.watchedNBT.addAll(this.watchedNBT);
        cp.extraNBT.putAll(this.extraNBT);
        cp.overrides.putAll(this.overrides);
        cp.ignoreSet.addAll(this.ignoreSet);
        cp.bounds = this.bounds;
        return cp;
    }

    public StructureExport copy(String path, Class c) {
        StructureExport cp = new StructureExport(this.name + "_copy", path, c);
        cp.encryptData = this.encryptData;
        cp.compressData = this.compressData;
        cp.data.putAll(this.data);
        cp.watchedNBT.addAll(this.watchedNBT);
        cp.extraNBT.putAll(this.extraNBT);
        cp.overrides.putAll(this.overrides);
        cp.ignoreSet.addAll(this.ignoreSet);
        cp.bounds = this.bounds;
        return cp;
    }

    public static interface NBTCallback {
        public NBTBase getOverriddenValue(Coordinate var1, BlockKey var2, String var3, NBTBase var4, NBTTagCompound var5);
    }

    public static interface PlacementCallback {
        public void onPlace(Coordinate var1, BlockKey var2, NBTTagCompound var3);
    }

    private static class TileNBTCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final NBTTagCompound tileData;

        private TileNBTCallback(NBTTagCompound tag) {
            this.tileData = tag;
        }

        @Override
        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te != null) {
                NBTTagCompound tag = new NBTTagCompound();
                te.func_145841_b(tag);
                ReikaNBTHelper.overwriteNBT(tag, this.tileData);
                te.func_145839_a(tag);
            }
        }
    }

    private static class BlockData {
        private final Coordinate position;
        private final BlockKey block;
        private final boolean hasTileEntity;
        private final NBTTagCompound tileData;

        private BlockData(World world, int x, int y, int z, HashSet<String> tags, HashMap<String, Object> extraTags, HashMap<String, NBTCallback> overrides) {
            this.position = new Coordinate(x, y, z);
            this.block = BlockKey.getAt((IBlockAccess)world, x, y, z);
            TileEntity te = world.func_147438_o(x, y, z);
            this.hasTileEntity = te != null;
            NBTTagCompound nBTTagCompound = this.tileData = te != null ? new NBTTagCompound() : null;
            if (te != null) {
                te.func_145841_b(this.tileData);
                BlockData.filterNBT(tags, this.tileData);
                ReikaNBTHelper.addMapToTags(this.tileData, extraTags);
                for (String s : overrides.keySet()) {
                    NBTBase tag = this.tileData.func_74781_a(s);
                    if (tag == null) continue;
                    tag = overrides.get(s).getOverriddenValue(this.position, this.block, s, tag.func_74737_b(), (NBTTagCompound)this.tileData.func_74737_b());
                    this.tileData.func_74782_a(s, tag);
                }
            }
        }

        private BlockData(Coordinate c, BlockKey bk, boolean tile, NBTTagCompound tileDat) {
            this.position = c;
            this.block = bk;
            this.hasTileEntity = tile;
            this.tileData = tileDat;
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound NBT = new NBTTagCompound();
            if (this.tileData != null) {
                NBT.func_74782_a("tiledat", (NBTBase)this.tileData);
            }
            NBT.func_74757_a("tile", this.hasTileEntity);
            this.position.writeToNBT("loc", NBT);
            this.block.writeToNBT("type", NBT);
            return NBT;
        }

        private static BlockData readFromNBT(NBTTagCompound NBT, HashSet<String> tags, HashMap<String, Object> extraTags) {
            NBTTagCompound tileDat = null;
            if (NBT.func_74764_b("tiledat")) {
                tileDat = NBT.func_74775_l("tiledat");
                BlockData.filterNBT(tags, tileDat);
                ReikaNBTHelper.addMapToTags(tileDat, extraTags);
            }
            Coordinate c = Coordinate.readFromNBT("loc", NBT);
            BlockKey bk = BlockKey.readFromNBT("type", NBT);
            if (bk == null) {
                return null;
            }
            boolean tile = NBT.func_74767_n("tile");
            return new BlockData(c, bk, tile, tileDat);
        }

        private static void filterNBT(HashSet<String> tags, NBTTagCompound tag) {
            Iterator it = tag.func_150296_c().iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (tags.contains(s)) continue;
                it.remove();
            }
        }

        private void place(World world) {
            TileEntity te;
            this.block.place(world, this.position.xCoord, this.position.yCoord, this.position.zCoord);
            if (this.hasTileEntity && (te = this.position.getTileEntity(world)) != null) {
                NBTTagCompound tag = new NBTTagCompound();
                te.func_145841_b(tag);
                ReikaNBTHelper.overwriteNBT(tag, this.tileData);
                te.func_145839_a(tag);
            }
        }

        private void place(ChunkSplicedGenerationCache world) {
            if (this.hasTileEntity) {
                TileNBTCallback call = new TileNBTCallback(this.tileData);
                world.setTileEntity(this.position.xCoord, this.position.yCoord, this.position.zCoord, this.block.blockID, this.block.metadata, call);
            } else {
                world.setBlock(this.position.xCoord, this.position.yCoord, this.position.zCoord, this.block);
            }
        }

        public BlockData offset(Coordinate offset) {
            return new BlockData(this.position.offset(offset), this.block, this.hasTileEntity, this.tileData);
        }

        public String toString() {
            return this.block + " @ " + this.position + " {" + this.tileData + "}";
        }
    }
}

